# Education in Valencia

## Overview

Valencia has a full range of educational options: Spanish public schools, semi-private (concertado), private Spanish, and international schools.

---

## School System Structure

### Spanish Education Levels

| Level | Ages | Years |
|-------|------|-------|
| Educación Infantil | 0-6 | Optional (free 3-6) |
| Educación Primaria | 6-12 | 6 years |
| Educación Secundaria (ESO) | 12-16 | 4 years |
| Bachillerato | 16-18 | 2 years (university track) |
| Formación Profesional | 16+ | Vocational track |

### Compulsory Education
- Ages 6-16
- Both tracks after ESO lead to further education/work

---

## Public Schools (Colegios Públicos)

### What They Offer
- Free education
- Spanish + Valenciano instruction
- Standard Spanish curriculum
- Local community integration

### Language of Instruction
Valencia has three models:
| Model | Primary Language | Secondary Language |
|-------|------------------|-------------------|
| PEV | Valenciano | Spanish |
| PIL | Spanish | Valenciano |
| PPEV | Progressive increase in Valenciano |

**Note**: Parents can choose, but availability depends on area.

### Quality
- Varies by school and area
- Some excellent, some struggling
- Check specific school ratings
- PISA scores: Spain around EU average

### How to Enroll
1. **Empadronamiento** required
2. **Enrollment period**: March-April for September start
3. **Assignment**: Based on address, proximity to school
4. **Points system**: Distance, siblings, etc.

### Documents Needed
- Child's passport
- Empadronamiento
- Previous school records
- Vaccination record
- Parents' ID/NIE

---

## Concertado Schools (Semi-Private)

### What They Are
- Privately run, publicly funded
- Often Catholic/religious affiliated
- Spanish curriculum
- Small fees for extras

### Cost
- Tuition: Free (publicly funded)
- Extras: €50-200/month (uniforms, activities, etc.)

### Advantages
- More stable staffing
- Often perceived as higher quality
- More resources
- Religious instruction (if desired)

### Popular Concertado Schools in Valencia
- Colegio La Purísima
- Colegio San José de Calasanz
- Colegio Jesús María
- Many others throughout city

---

## Private Spanish Schools

### What They Offer
- Spanish curriculum
- Smaller class sizes
- More resources
- Some offer bilingual programs

### Cost
- €300-700/month typical
- Varies widely by school

### Examples
- Colegio Mas Camarena
- Colegio CEU San Pablo
- Colegio Alemán (German)
- Liceo Francés (French)

---

## International Schools

### Why Choose International
- Curriculum in English (or other language)
- Easier transition for expat children
- International qualifications (IB, A-Levels)
- Diverse student body

### Cost
| School Type | Annual Cost |
|-------------|-------------|
| Mid-range international | €8,000-12,000 |
| Premium international | €12,000-18,000 |
| Top-tier (British/American) | €15,000-25,000 |

### International Schools in Valencia

**British Curriculum:**
| School | Location | Cost (approx) |
|--------|----------|---------------|
| Caxton College | Puçol | €10,000-15,000 |
| The British School of Valencia | Godella | €8,000-12,000 |
| Cambridge House | Rocafort | €10,000-14,000 |

**American Curriculum:**
| School | Location | Cost (approx) |
|--------|----------|---------------|
| American School of Valencia | Puçol | €12,000-18,000 |

**IB Schools:**
| School | Location | Cost (approx) |
|--------|----------|---------------|
| SEK International | Alboraya | €10,000-15,000 |

**Other:**
| School | Curriculum | Location |
|--------|------------|----------|
| Lycée Français | French | Paterna |
| Deutsche Schule | German | Centro |

### Choosing a School

**Consider**:
- How long you're staying
- Child's current language abilities
- University destinations (UK, US, Spain, etc.)
- Commute from home
- Extracurricular offerings
- Community fit

**If staying short-term**: International maintains continuity
**If staying long-term**: Local school = better integration

---

## Universities

### Public Universities

| University | Strengths | Students |
|------------|-----------|----------|
| Universidad de Valencia (UV) | Humanities, sciences | 50,000+ |
| Universidad Politécnica de Valencia (UPV) | Engineering, architecture | 30,000+ |

### Private Universities

| University | Focus |
|------------|-------|
| Universidad Católica de Valencia | Various |
| Universidad Europea de Valencia | Various |
| CEU Cardenal Herrera | Healthcare, communications |

### Costs
- Public: €800-2,000/year (EU residents)
- Public (non-EU): €2,000-5,000/year
- Private: €8,000-20,000/year

### Admission
- Spanish students: PAU exam (Selectividad)
- International: Varies, often direct admission
- Language requirements: Spanish for most programs

### English Programs
- Growing but limited
- More at private universities
- Masters more likely than undergraduate

---

## Language Learning

### For Children
**If entering Spanish school**:
- Immersion works quickly (6-12 months)
- Support classes often available
- Younger = faster adaptation
- Pre-arrival tutoring helpful

**International schools**:
- Often offer Spanish classes
- Integration with locals harder

### For Adults

**Language Schools:**
| School | Notes |
|--------|-------|
| Hispania | Popular, central |
| Taronja | Social, activities |
| Don Quijote | Chain, good quality |
| Costa de Valencia | Various programs |

**Cost**: €150-300/week intensive; €50-150/week standard

**Free/Cheap Options**:
- Intercambio (language exchange) meetups
- Apps (Duolingo, Babbel)
- Community center classes
- University extension courses

---

## Childcare (0-3 years)

### Options

**Escuelas Infantiles (Public Nurseries)**:
- Ages 0-3
- Very affordable (€50-300/month based on income)
- Limited spots, apply early
- Quality varies

**Private Nurseries**:
- More availability
- €300-600/month typical
- More flexible hours

**Au Pairs**:
- Popular option
- Room + board + €70-100/week
- Through agencies or websites

**Nannies**:
- €8-12/hour typical
- Can register formally (as employer)
- Or informal arrangements

---

## Special Education Needs

### Public System
- Support available but variable
- Assessment through Centro de Salud
- Specialist teachers in some schools
- Integration (inclusive) approach

### Private Options
- More resources typically
- Specialist schools exist
- International schools vary
- Research specific school capabilities

---

## Homeschooling

### Legal Status
- **Technically**: Not explicitly legal in Spain
- **Practice**: Tolerated but gray area
- **Requirements**: Register children as schooled somewhere
- **Community**: Growing homeschool groups in Valencia

### Reality
- Some families do it
- Often register with online schools (US, UK)
- Less common than in US/UK
- Socializing requires extra effort

---

## School Calendar

### Academic Year
- **Start**: Early-mid September
- **End**: Mid-late June
- **Christmas break**: ~2 weeks
- **Easter break**: ~1-2 weeks
- **Summer**: July-August (off)

### Holidays
- National Spanish holidays
- Valencian holidays (Fallas = often a week off)
- School-specific days

---

## Practical Tips

### Enrollment Timeline
1. **January-February**: Research schools
2. **March-April**: Public school enrollment opens
3. **April-May**: Deadlines for most
4. **June**: Assignments
5. **September**: School starts

### International School Tips
- Apply 6-12 months ahead for popular schools
- Waiting lists common
- Visit schools in person
- Ask about integration support

### Adaptation
- Expect adjustment period (3-6 months)
- Encourage local friendships
- Balance: Some English refuge okay
- After-school activities help integration

---

## Resources

| Resource | Contact |
|----------|---------|
| Valencian Education | ceice.gva.es |
| School finder | gva.es/es/buscador-colegios |
| International schools | nabss.org (British) |
| University admission | uv.es, upv.es |
