# Driving in Valencia

## Do You Need a Car?

### Probably Not If:
- Living in Centro, Ruzafa, beach areas
- Working remotely or in Centro
- Comfortable with public transit
- No kids or kids in local school

### Maybe Yes If:
- Family with kids in suburban/international schools
- Regular trips outside Valencia
- Working in business parks
- Living in outer suburbs
- Frequent La Albufera, wine country visits

### The Reality
Valencia is one of the most car-free-friendly Spanish cities:
- Excellent metro system
- Valenbisi bike share
- Compact walkable core
- Taxis/rideshare available

---

## Driving License

### EU Citizens
- EU license valid indefinitely
- No conversion needed
- Register if becoming resident (voluntary)

### Non-EU Citizens

**First 6 months**:
- Home country license valid
- International Driving Permit recommended

**After 6 months**:
- Must convert to Spanish license
- Process depends on nationality

**Conversion Process (Canje)**

Countries with agreements (direct exchange):
- Most of Latin America
- Japan, South Korea
- Some others

Process:
1. Apply at DGT (traffic authority)
2. Submit: Original license, passport, NIE, photos
3. Pay fee (~€28)
4. Receive Spanish license

**Countries without agreement (must test)**:
- USA, Canada, Australia, UK (post-Brexit)
- Must pass Spanish driving test
- Theory + practical exam
- In Spanish (or with certified translator)

### Getting a Spanish License from Scratch
1. Enroll in autoescuela (driving school)
2. Study theory (available in English at some)
3. Pass theory exam
4. Practice driving
5. Pass practical exam
6. Cost: €500-1,000+ total

---

## Buying a Car

### New Cars
- Dealerships throughout city
- Standard European brands available
- Leasing options exist

### Used Cars
| Platform | Notes |
|----------|-------|
| Wallapop | Most popular |
| Milanuncios | Also popular |
| Coches.com | Aggregator |
| Autoscout24 | European platform |
| Dealers | More expensive but warranties |

### What to Check (Used)
- ITV (inspection) valid
- No outstanding finance
- Service history
- Accident history
- Actual km (fraud exists)

### Registration Process
1. Sales contract (contrato de compraventa)
2. Pay transfer tax (4-8% of value)
3. Register at DGT
4. Get new registration document
5. Update insurance

### Costs
| Item | Cost |
|------|------|
| Transfer tax | 4-8% of value |
| DGT registration | ~€55 |
| Plates (if needed) | €30-50 |

---

## Owning a Car

### Ongoing Costs

| Item | Annual/Monthly Cost |
|------|---------------------|
| Insurance | €300-600/year |
| Road tax (IVTM) | €50-150/year |
| ITV (inspection) | €30-50/year (after 4 years) |
| Fuel | €100-200/month |
| Parking (garage) | €80-150/month |
| Maintenance | Variable |

### Insurance
- Third party minimum required
- Fully comprehensive (todo riesgo) recommended
- Providers: Mapfre, AXA, Mutua Madrileña, etc.
- Get multiple quotes
- Online platforms: Rastreator, Acierto

### ITV (Inspection)
- First ITV at 4 years old
- Then every 2 years until 10 years old
- Then annually
- Cost: €30-50
- Book at ITV stations

---

## Parking

### Centro Histórico
- **Very difficult**
- Mostly pedestrian zones
- Limited street parking (residents only)
- Public garages: €2-3/hour

### Ruzafa / Eixample
- **Difficult but possible**
- Resident parking zones (zona azul/verde)
- Some street parking
- Garages available

### Beach Areas
- **Easier**
- More street parking
- Summer = crowded

### Suburbs
- **Easy**
- Most buildings have parking
- Street parking available

### Parking Zones
- **Blue zone (azul)**: Paid, max 2 hours, €1-2/hour
- **Green zone (verde)**: Residents preferred, some visitor hours
- **Orange zone (naranja)**: Residents only

### Public Garages
| Location | Approximate Daily Rate |
|----------|----------------------|
| Centro | €15-25 |
| Ruzafa | €12-20 |
| Beach | €10-15 |

### Apps
- ElParking
- Parclick
- Parkimeter

---

## Traffic Rules

### Basics
| Rule | Details |
|------|---------|
| Side of road | Right |
| Speed (urban) | 30-50 km/h |
| Speed (highway) | 120 km/h |
| Speed (secondary) | 90 km/h |
| Alcohol limit | 0.5 g/L (0.3 new drivers) |
| Phone | Hands-free only |
| Seat belts | Mandatory all seats |
| Children | Car seats required |

### Speed Limits
- Urban residential: 30 km/h
- Urban main streets: 50 km/h
- Ring roads: 80 km/h
- Highways (autopistas): 120 km/h
- Secondary roads: 90 km/h

### Fines
| Infraction | Fine Range |
|------------|-----------|
| Speeding (minor) | €100-300 |
| Speeding (major) | €300-600 |
| Red light | €200 |
| Phone use | €200 |
| No seat belt | €200 |
| Drunk driving | €500-1,000+ |

### Points System
- Start with 12 points (8 for new drivers)
- Infractions deduct points
- Lose all = license suspended

---

## Navigation

### Apps
- **Google Maps**: Works well
- **Waze**: Good for traffic
- **RACC**: Spanish AA/AAA equivalent app

### Common Routes
| Route | Notes |
|-------|-------|
| A-7 | Coast road south (Alicante) |
| A-3 | Madrid direction |
| V-31 | Ring road south |
| V-30 | Ring road |
| A-23 | North (Teruel, Zaragoza) |

### Tolls
- Most highways around Valencia are free
- Some AP roads charge tolls
- Pay by card or cash

---

## Car Rentals

### When to Rent
- Day trips outside city
- Airport pickup/dropoff
- Temporary needs
- Testing before buying

### Companies
| Company | Notes |
|---------|-------|
| Europcar | Major, reliable |
| Hertz | Major |
| Avis | Major |
| Sixt | Good selection |
| Goldcar | Budget, check reviews |
| OK Rent | Local budget option |

### Prices
- Small car: €20-40/day
- Medium car: €30-50/day
- Weekly: Significant discounts
- Book ahead for better rates

### Tips
- Check insurance coverage carefully
- Full-full fuel policy preferred
- Take photos of any damage
- Automatic transmission costs more
- Airport locations often cheaper

---

## Electric Vehicles

### Charging Infrastructure
- Growing network
- Public chargers increasing
- Home charging where possible

### Charging Networks
- Iberdrola
- Endesa
- Tesla Superchargers

### Incentives
- Purchase subsidies (Plan MOVES)
- Reduced parking fees
- Some toll exemptions
- Lower road tax

---

## Motorcycles & Scooters

### Popular Option
- Easier parking
- Lane filtering legal (with care)
- Lower costs

### License
- A1, A2, A (different power levels)
- B license: Can ride up to 125cc with 3+ years experience

### Electric Scooters
- Rentals: Yego, Cooltra
- Personal: Registration required
- Rules similar to bicycles (dedicated lanes)

---

## Practical Tips

1. **Don't drive in Centro** — Pedestrian zones, no parking
2. **Rush hour**: 08:00-09:30, 14:00-15:00, 18:00-20:00
3. **Roundabouts**: Priority to traffic already in circle
4. **Zebra crossings**: Pedestrians have right of way
5. **Double parking**: Common but illegal
6. **August**: Empty roads, great driving
7. **Fallas**: Avoid Centro entirely by car
8. **Rain**: Roads get very slippery (rare rain + oil)

---

## Useful Contacts

| Service | Contact |
|---------|---------|
| DGT (Traffic authority) | dgt.es |
| RACC (roadside assistance) | racc.es |
| Emergency | 112 |
| Traffic info | @DGTes on Twitter |
| ITV booking | Varies by station |
