# Business Setup in Valencia

## Overview

Starting a business in Spain involves bureaucracy but is manageable. Options range from simple freelancer status to full company formation.

---

## Business Structures

### Autónomo (Self-Employed)

**What it is**: Freelancer/sole proprietor status

**Best for**:
- Freelancers
- Consultants
- Small-scale businesses
- Testing business ideas

**Pros**:
- Simple setup (1-2 weeks)
- Low startup costs
- Easy accounting
- Can invoice immediately

**Cons**:
- Unlimited personal liability
- Fixed Social Security cost regardless of income
- Higher tax rates at higher income

**Costs**:
| Item | Cost |
|------|------|
| Registration | Free |
| Social Security (Year 1) | ~€80/month (tarifa plana) |
| Social Security (Year 2) | ~€140/month |
| Social Security (Year 3+) | ~€300/month minimum |
| Gestoría (optional) | €50-100/month |

### Sociedad Limitada (S.L.) — Limited Company

**What it is**: Spanish equivalent of LLC

**Best for**:
- Higher revenue businesses
- Multiple founders
- Limiting personal liability
- Professional image

**Pros**:
- Limited liability
- Lower corporate tax rate (25%)
- Professional credibility
- Easier to raise investment

**Cons**:
- €3,000 minimum capital
- More complex accounting
- Higher compliance costs
- Annual accounts filing

**Costs**:
| Item | Cost |
|------|------|
| Minimum capital | €3,000 |
| Notary + registration | €500-1,000 |
| Setup (with gestoría) | €500-1,000 |
| Annual accounting | €100-300/month |
| Corporate tax | 25% (15% first 2 years for new companies) |

### S.L. vs Autónomo Decision

| Factor | Autónomo | S.L. |
|--------|----------|------|
| Annual revenue | <€40-50K | >€40-50K |
| Risk | Low | Higher (liability matters) |
| Partners | No | Yes |
| Investment | No | Planning to raise |
| Image | Personal | Corporate |

**Rule of thumb**: Start autónomo, convert to S.L. when revenue justifies it (~€40-50K/year).

---

## Registering as Autónomo

### Step-by-Step Process

**Week 1: Preparation**
1. Get NIE (if not already done)
2. Open bank account
3. Choose your activity (CNAE code)
4. Decide on gestoría or DIY

**Registration Steps**
1. **Hacienda (Tax Office)**: Register via Model 036/037
   - Declare your activity
   - Choose tax regime
   - Get started for VAT if applicable

2. **Social Security (TGSS)**: Register as autónomo
   - Within 60 days of Hacienda registration
   - Choose contribution base
   - Set up direct debit

**Timeline**: 1-2 weeks if prepared

### Tarifa Plana (Reduced Rate)

New autónomos get reduced Social Security:
- **Months 1-12**: ~€80/month
- **Months 13-18**: ~€140/month  
- **Months 19-24**: ~€140/month
- **Month 25+**: Full rate (~€300+ based on income)

**Eligibility**:
- Not been autónomo in past 2 years
- No outstanding Social Security debts

---

## Forming an S.L.

### Process

1. **Obtain certificate of name availability**
   - Mercantile Registry
   - Reserve company name

2. **Open bank account**
   - Deposit €3,000 minimum capital
   - Get bank certificate

3. **Draft bylaws**
   - Notary prepares
   - Or use standard template

4. **Sign before notary**
   - All founders present
   - Notary deed created

5. **Register with Mercantile Registry**
   - Submit deed
   - 1-2 weeks processing

6. **Get CIF (tax ID)**
   - At Hacienda
   - Company now operational

7. **Administrator as autónomo**
   - Majority shareholders who manage must register as autónomo

**Timeline**: 2-4 weeks with gestoría

---

## Taxes

### Autónomo Taxes

| Tax | Rate | When |
|-----|------|------|
| IRPF (income tax) | 19-47% progressive | Quarterly + annual |
| IVA (VAT) | 21% (10% or 4% reduced) | Quarterly |
| Quarterly payments | 20% of profit | Model 130 |

### S.L. Taxes

| Tax | Rate | When |
|-----|------|------|
| Corporate tax | 25% (15% new companies) | Annual |
| IVA (VAT) | 21% | Quarterly/monthly |
| Dividend withholding | 19% | When distributed |

### VAT (IVA) Notes
- Most services: 21%
- Some goods: 10%
- Basic necessities: 4%
- EU B2B: Reverse charge (0%)
- Non-EU exports: 0%

---

## Banking for Business

### Business Accounts

| Bank | Monthly Fee | Notes |
|------|-------------|-------|
| Qonto | €9-29 | Modern, good UX |
| Holvi | €9-15 | Freelancer-focused |
| N26 Business | €0 | Basic but free |
| Sabadell | €0-15 | Traditional |
| CaixaBank | €0-20 | Large network |

### What You Need
- NIE
- Registration documents
- Proof of activity
- ID

### Accounting Software
- Holded: Spanish, integrated
- Quaderno: For digital businesses
- Quipu: Popular for autónomos
- Xero/Quickbooks: International options

---

## Hiring Employees

### Cost Reality

For every €1,000 gross salary:
- Employee receives: ~€850 (after IRPF withholding)
- Employer pays: ~€1,300+ (with Social Security)

**Employer Social Security**: ~30% of gross salary

### Contract Types
| Type | Use Case |
|------|----------|
| Indefinido | Permanent, standard |
| Temporal | Project-based, limited |
| Prácticas | Internship, recent grads |
| Formación | Training contracts |

### Minimum Wage (2024)
- €1,134/month (14 payments)
- Or €15,876/year

### Hiring Process
1. Register with Social Security as employer
2. Draft contract (standard templates)
3. Register employee
4. Monthly payroll and contributions
5. Annual reporting

**Recommendation**: Use gestoría for first employee

---

## Coworking & Office Space

### Coworking Options

| Space | Location | Price |
|-------|----------|-------|
| Wayco | Multiple | €150-250/month |
| La Pinada | Ruzafa | €150-200/month |
| Impact Hub | Ruzafa | €200-300/month |
| Lanzadera | Marina | Free (startups) |
| WeWork | Centro | €300-400/month |

### Office Rent
- Small office (2-4 people): €400-800/month
- Larger office: €15-25/m²/month
- Cheaper than Madrid/Barcelona by 30-40%

### Business Address
- Can use coworking address
- Virtual office services: €30-50/month
- Home address allowed for autónomos

---

## Invoicing

### Required Elements
- Your name/company + NIF/CIF
- Client name + NIF/CIF
- Invoice number (sequential)
- Date
- Description of services/goods
- Net amount
- VAT amount and rate
- Total amount
- Payment terms

### IRPF Retention
- When invoicing Spanish companies: They withhold 15% IRPF
- When invoicing individuals or non-Spanish: No retention

### Ticketbai / VeriFACTU
- Electronic invoicing requirements coming
- Some regions already mandatory
- Software must be certified

---

## Compliance Calendar

### Quarterly (Autónomo)
| Model | Purpose | Deadline |
|-------|---------|----------|
| 303 | VAT declaration | 20th of month after quarter |
| 130 | IRPF advance payment | 20th of month after quarter |
| 349 | EU operations (if any) | 20th of month after quarter |

### Annual (Autónomo)
| Model | Purpose | Deadline |
|-------|---------|----------|
| 390 | Annual VAT summary | January 30 |
| 100 | Annual income tax | June 30 |
| 347 | Operations >€3,005 | February |

### S.L. Additional
| Model | Purpose | Deadline |
|-------|---------|----------|
| 200 | Corporate tax | July 25 |
| 111 | Employee withholdings | Monthly/quarterly |
| 190 | Annual withholding summary | January |

---

## Getting Help

### Gestoría Services
- Tax filings: €50-100/month (autónomo)
- Full accounting: €100-300/month (S.L.)
- Setup assistance: €200-500

### Finding a Gestor
- Ask expat community
- Google "gestoría Valencia inglés"
- Check reviews
- Interview 2-3 before deciding

### Lawyers
- For complex setups or disputes
- €100-300/hour typical
- Essential for investment rounds

---

## Tips for Success

1. **Start as autónomo** unless you have strong reasons for S.L.
2. **Use a gestoría** at least for first year
3. **Separate business banking** from personal
4. **Track expenses** from day one
5. **Save for taxes** (30-40% of profit)
6. **Join startup ecosystem** for resources and connections
7. **Invoice properly** to avoid problems later
8. **Don't skip Social Security** — consequences are severe
