---
name: Valencia
slug: valencia
version: 1.0.0
homepage: https://clawic.com/skills/valencia
description: Navigate Valencia as visitor, resident, tech worker, student, or entrepreneur with neighborhoods, transport, costs, visas, and local insights.
metadata: {"clawdbot":{"emoji":"🍊","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## When to Use

User asks about Valencia for any purpose: visiting, moving, working, studying, or starting a business. Agent provides practical guidance with current data.

## Setup

See `setup.md` for first-time configuration and `memory-template.md` for tracking your Valencia journey.

## Quick Reference

| Topic | File |
|-------|------|
| **Setup** | |
| First-time setup guide | `setup.md` |
| Personal profile template | `memory-template.md` |
| **Visitors** | |
| Attractions (must-see vs skip) | `visitor-attractions.md` |
| Itineraries (1/3/7 days) | `visitor-itineraries.md` |
| Where to stay | `visitor-lodging.md` |
| Tips & day trips | `visitor-tips.md` |
| **Neighborhoods** | |
| Quick comparison | `neighborhoods-index.md` |
| Centro Histórico, Eixample, La Seu | `neighborhoods-centro.md` |
| Ruzafa, Russafa | `neighborhoods-ruzafa.md` |
| Poblats Marítims, Malvarrosa, El Cabanyal | `neighborhoods-beach.md` |
| Patraix, Benimaclet, Campanar | `neighborhoods-residential.md` |
| Choosing guide | `neighborhoods-choosing.md` |
| **Food** | |
| Overview & dining scene | `food-overview.md` |
| Valencian cuisine & paella | `food-local.md` |
| International & fine dining | `food-international.md` |
| Best areas for dining | `food-areas.md` |
| Horarios, tipping, reservations | `food-practical.md` |
| **Practical** | |
| Moving & settling | `resident.md` |
| Transport (metro, bus, Valenbisi) | `transport.md` |
| Cost of living | `cost.md` |
| Safety & laws | `safety.md` |
| Weather & best times | `climate.md` |
| Local services (banking, NIE) | `local.md` |
| **Career** | |
| Tech industry & salaries | `tech.md` |
| Business setup & autónomo | `business.md` |
| Visas (EU, non-EU, digital nomad) | `visas.md` |
| Startups & ecosystem | `startup.md` |
| **Lifestyle** | |
| Culture & customs | `culture.md` |
| Healthcare & insurance | `healthcare.md` |
| Schools & education | `education.md` |
| Expat lifestyle & social | `lifestyle.md` |
| Driving & car ownership | `driving.md` |

## Core Rules

### 1. Identify User Context First
- **Role**: Tourist, resident, tech worker, student, entrepreneur, digital nomad
- **Timeline**: Short visit, planning to move, already there
- **EU status**: EU citizen (easy move) vs non-EU (visa requirements)
- Load relevant auxiliary file for details

### 2. Third-Largest City
Valencia is Spain's third-largest city (~800,000, metro ~1.8M):
- More affordable than Madrid/Barcelona with similar quality of life
- Mediterranean climate — 300+ sunny days per year
- Beach + city combination rare in European capitals
- Growing tech hub with foreign investment
See `cost.md` for living expenses and `lifestyle.md` for quality of life.

### 3. Language Reality
Valencia is bilingual:
- **Castellano (Spanish)**: Everyone speaks it, all business conducted in it
- **Valenciano (Valencià)**: Co-official, used in some signage and government
- English widely spoken in tourist areas, tech companies, and by younger generation
- Learning basic Spanish essential for integration
See `culture.md` for language tips.

### 4. Climate Advantage
Mediterranean climate is Valencia's biggest draw:
- **Summer (Jun-Sep)**: 28-35°C, beach weather, some humidity
- **Winter (Dec-Feb)**: 10-18°C, mild, occasional rain
- **Spring/Fall**: Perfect 20-26°C
- 300+ sunny days per year — significant for northern Europeans
See `climate.md` for monthly breakdown.

### 5. Current Data (Feb 2026)

| Item | Range |
|------|-------|
| 1BR rent (Centro) | €800-1,200/month |
| 1BR rent (Ruzafa) | €900-1,300/month |
| 1BR rent (Periferia) | €550-800/month |
| Senior SWE salary | €45,000-70,000/year |
| Metro monthly pass | €45 (zones ABC) |
| Lunch menú del día | €12-18 |
| International school | €8,000-18,000/year |

### 6. Cost Reality
Valencia offers excellent value for Western Europe:
- **Housing**: 40-50% cheaper than Barcelona, 30% cheaper than Madrid
- **Dining**: Quality restaurants at half Barcelona prices
- **Transport**: Affordable public transit and bike-friendly
- **Healthcare**: Public system free for residents; private €50-150/month
- **Rising prices**: Post-2020 influx of remote workers has increased rents 20-30%

### 7. Transit Excellence
Unlike many Spanish cities, Valencia has excellent public transport:
- **Metro/Tram**: 9 lines covering most of the city and airport
- **EMT Buses**: Dense network, real-time apps
- **Valenbisi**: 275 bike stations, €30/year subscription
- **Walking**: Centro Histórico and Ruzafa highly walkable
- **No car needed**: Unlike Madrid, you can live comfortably without a car
See `transport.md` for details.

### 8. Neighborhood Matching

| Profile | Best Areas |
|---------|------------|
| Young professionals | Ruzafa, Benimaclet, El Carmen |
| Families | Campanar, Patraix, Benimaclet |
| Beach lovers | El Cabanyal, Malvarrosa, Patacona |
| Budget-conscious | Benimaclet, Patraix, La Saïdia |
| Tech workers | Ruzafa, Ciudad de las Artes, Quatre Carreres |
| Students | Benimaclet, Blasco Ibáñez area |
| Digital nomads | Ruzafa, Centro, El Carmen |

## Startup & Tech Context

Valencia's tech ecosystem is growing rapidly:
- **Marina de Empresas**: Major startup hub with Lanzadera accelerator
- **Ciudad Politécnica**: University-linked innovation
- **Foreign investment**: Growing presence of international companies
- **Cost advantage**: 40-50% cheaper than Barcelona for office space and talent
- **Quality of life**: Major attraction for recruiting international talent

See `startup.md` and `tech.md` for ecosystem details.

## Valencia-Specific Traps

- **Siesta hours** — Many shops close 14:00-17:00. Supermarkets stay open.
- **Spanish bureaucracy** — NIE, empadronamiento, gestoría often needed. Budget time and patience.
- **Rental scams** — Never pay without visiting. Idealista is safest. Watch for fake listings.
- **August shutdown** — Many businesses close 2-3 weeks. Plan accordingly.
- **Paella timing** — Valencians eat paella at LUNCH (13:00-15:00), never dinner. Tourist restaurants ignore this.
- **Beach vs Centro trade-off** — Beach areas are 20-30 min from Centro. Choose based on lifestyle.
- **Valenciano pressure** — Some government services prefer Valenciano. Spanish always accepted legally.
- **Fallas chaos** — March 15-19: amazing but LOUD. Book early or leave entirely.
- **Northern European expectations** — Things move slower. Adapt to local pace.
- **Banking hours** — Most banks close at 14:00. Digital banking is easier.

## Legal Awareness (Non-EU)

Key requirements for non-EU citizens:
- **Digital Nomad Visa**: Available since 2023, requires €2,520/month income
- **Autónomo**: Self-employed visa requires business plan and startup capital
- **Non-lucrative Visa**: For retirees/wealthy, no work permitted
- **Student Visa**: Allows limited work (20h/week)
- **EU family**: Spouses of EU citizens get residence card

See `visas.md` for comprehensive requirements.

## EU Citizen Advantage

EU citizens can:
- Move without visa, work immediately
- Register (empadronamiento) and get NIE within weeks
- Access public healthcare with EHIC initially, full access after registration
- Bring non-EU family members relatively easily

See `resident.md` for EU citizen process.

## Related Skills
Install with `clawhub install <slug>` if user confirms:

- `dubai` — Compare with another popular expat destination
- `travel` — Planning trips and itineraries
- `spanish` — Learn the language for deeper integration
- `business` — Business strategy and planning
- `real-estate-skill` — Property buying and investment

## Feedback

- If useful: `clawhub star valencia`
- Stay updated: `clawhub sync`
