# WCAG 2.1 Principles (POUR)

This document provides a high-level summary of the four core principles of the Web Content Accessibility Guidelines (WCAG). Use these principles as a foundation for all accessibility evaluations.

## 1. Perceivable

Information and user interface components must be presentable to users in ways they can perceive. This means that users must be able to perceive the information being presented (it can't be invisible to all of their senses).

### Key Guidelines:
- **Text Alternatives:** Provide text alternatives for any non-text content (e.g., `alt` text for images).
- **Time-Based Media:** Provide alternatives for time-based media (e.g., captions for videos).
- **Adaptable:** Create content that can be presented in different ways (e.g., simpler layout) without losing information or structure.
- **Distinguishable:** Make it easier for users to see and hear content including separating foreground from background (e.g., sufficient color contrast).

## 2. Operable

User interface components and navigation must be operable. This means that users must be able to operate the interface (the interface cannot require interaction that a user cannot perform).

### Key Guidelines:
- **Keyboard Accessible:** Make all functionality available from a keyboard.
- **Enough Time:** Provide users enough time to read and use content.
- **Seizures and Physical Reactions:** Do not design content in a way that is known to cause seizures.
- **Navigable:** Provide ways to help users navigate, find content, and determine where they are.
- **Input Modalities:** Make it easier for users to operate functionality through various inputs beyond keyboard.

## 3. Understandable

Information and the operation of user interface must be understandable. This means that users must be able to understand the information as well as the operation of the user interface (the content or operation cannot be beyond their understanding).

### Key Guidelines:
- **Readable:** Make text content readable and understandable.
- **Predictable:** Make Web pages appear and operate in predictable ways.
- **Input Assistance:** Help users avoid and correct mistakes.

## 4. Robust

Content must be robust enough that it can be interpreted reliably by a wide variety of user agents, including assistive technologies. This means that as technologies and user agents evolve, the content should remain accessible.

### Key Guidelines:
- **Compatible:** Maximize compatibility with current and future user agents, including assistive technologies.

*This summary is based on the principles outlined in the W3C Web Content Accessibility Guidelines 2.1.*
