# Material Design 3

Material Design is Google's open-source design system. Material 3 (M3) is the latest version, emphasizing expressive, adaptive, and personal UIs. Use these principles when evaluating or creating designs for Android or cross-platform applications that adopt the Material look and feel.

## Core Principles

Material Design is built on three core principles that guide the design process.

1.  **Material is the Metaphor:** The design is a rationalized space and a system of motion. The material is grounded in tactile reality, inspired by paper and ink, yet technologically advanced and open to imagination and magic.
2.  **Bold, Graphic, Intentional:** The foundational elements of print-based design—typography, grids, space, scale, color, and use of imagery—guide visual treatments. These elements do far more than please the eye. They create hierarchy, meaning, and focus.
3.  **Motion Provides Meaning:** Motion focuses attention and maintains continuity. Feedback is subtle yet clear. Transitions are efficient yet coherent.

## Key Features of Material 3 (Material You)

Material 3, also known as Material You, introduces several key features that make UIs more personal and expressive.

-   **Dynamic Color:** The UI can automatically adapt its color palette based on the user's wallpaper and other system-level settings. This creates a more personal and cohesive experience.
-   **Expressive Components:** Components are designed to be more flexible and expressive, with updated styles, new components, and more customization options.
-   **Adaptive Layouts:** The system provides guidance and components for building layouts that adapt to different screen sizes and orientations, from mobile phones to large-screen devices.
-   **Updated Typography and Shapes:** A refreshed type scale and new options for shape allow for more expressive and legible UIs.

## When to Use Material Design

-   **Android Apps:** It is the default design system for Android. Following Material guidelines ensures a consistent and familiar experience for users.
-   **Cross-Platform Apps:** Many cross-platform frameworks (like Flutter and React Native) have strong support for Material Design, making it a good choice for creating a consistent look and feel across platforms.
-   **Web Apps:** Material can be used for web applications, especially those that are part of a broader ecosystem of products that use Material Design.

*This summary is based on the official Material Design 3 documentation.*
