# Apple Human Interface Guidelines (HIG)

Apple's Human Interface Guidelines (HIG) provide a comprehensive set of recommendations and best practices for designing great experiences on Apple platforms (iOS, iPadOS, macOS, watchOS, tvOS). The HIG emphasizes clarity, deference, and depth.

## Core Themes

-   **Clarity:** Text should be legible at every size, icons should be precise and lucid, adornments should be subtle and appropriate, and a sharpened focus on functionality should motivate the design.
-   **Deference:** The UI should help users understand and interact with the content, but never compete with it. Content typically fills the entire screen, while translucency and blurring of the UI hint at more.
-   **Depth:** Visual layers and realistic motion convey hierarchy, impart vitality, and facilitate understanding. Touch and discoverability heighten delight and enable access to functionality without losing context.

## Design Principles

The HIG is organized around several key design principles:

-   **Aesthetic Integrity:** How well an app's appearance and behavior integrate with its function.
-   **Consistency:** Using system-provided interface elements, well-known icons, standard text styles, and uniform terminology.
-   **Direct Manipulation:** The direct manipulation of onscreen content. Users experience direct manipulation when they rotate the device or use gestures to affect onscreen content.
-   **Feedback:** Acknowledging actions and showing results to keep people informed.
-   **Metaphors:** When virtual objects and actions in an app are metaphors for familiar experiences—whether rooted in the real or digital world—users quickly grasp the app's concepts.
-   **User Control:** Putting users in control. An app can make people feel like they're in control by keeping interactive elements familiar and predictable, confirming destructive actions, and making it easy to cancel operations.

## When to Use the HIG

-   **iOS, iPadOS, macOS, watchOS, and tvOS apps:** Adherence to the HIG is crucial for creating an app that feels at home on Apple platforms.
-   **Designing for the Apple Ecosystem:** Even if you are not building a native app, understanding the HIG can provide valuable insights into designing for users who are accustomed to the Apple ecosystem.

*This summary is based on the official Apple Human Interface Guidelines.*
