# Utrecht — Visitor Tips

## Essential First-Day Knowledge

### OV-Chipkaart
The universal transit card for all Dutch public transport.
- **Buy at**: Station ticket machines, tobacco shops
- **Cost**: €7.50 for card + credit
- **Load credit**: Machines accept cards and cash
- **Check in/out**: Tap at every entry/exit (trains, trams, buses)
- **Pro tip**: Anonymous card fine for visitors

### NS App (Trains)
- Download before arrival
- Real-time schedules, delays, platform changes
- Works for all Dutch trains
- Can buy tickets in app

### Cash vs Card
- **Cards**: Accepted almost everywhere
- **Contactless**: Works everywhere (Apple/Google Pay too)
- **Cash**: Less common, some small shops/markets only
- **Tip**: Carry €20-50 for small purchases, markets

### Language
- **Dutch**: Official language
- **English**: Universally spoken, exceptionally well
- No need to learn Dutch for a visit
- Simple phrases appreciated: "Dank je wel" (thanks)

## Money Saving Tips

### Free Things
- Walk along Oudegracht (best free activity)
- Pandhof cloister garden
- Parks: Wilhelminapark, Lepelenburg, Griftpark
- Trajectum Lumen (night light walk)
- Church interiors (Domkerk, etc.)
- Street markets (browsing)

### Cheap Eats
- **Broodje** (sandwiches): €5-8
- **Febo**: Automat fast food, Dutch experience
- **Supermarket lunch**: Albert Heijn to-go section
- **Lunch deals**: Many restaurants have affordable lunch menus
- **Ethnic food**: Lombok neighborhood, excellent value

### Museum Savings
- **Museumkaart**: €65/year, unlimited access — worth it if visiting 4+ museums
- **Utrecht City Card**: Day passes include transport + attractions
- **Student discounts**: Always ask, most places offer them

### Transport Savings
- **Walk**: Center is very compact
- **OV-fiets**: €4.55/day bike rental at station
- **Day tickets**: Unlimited bus/tram if making multiple trips

## Weather Preparation

### Year-Round Reality
- Rain possible ANY day (average 130+ rainy days/year)
- Weather changes quickly
- Dress in layers always

### What to Pack

| Season | Essentials |
|--------|------------|
| Spring (Mar-May) | Light jacket, waterproof layer, layers |
| Summer (Jun-Aug) | Light clothes + rain jacket, sunscreen |
| Fall (Sep-Nov) | Warm layers, waterproof jacket, scarf |
| Winter (Dec-Feb) | Warm coat, hat, gloves, waterproof boots |

### Local Wisdom
- "No bad weather, only bad clothing"
- Umbrellas often useless (wind + rain combo)
- Rain jackets > umbrellas
- Wind can be brutal — secure loose items

## Cultural Quick Guide

### Dutch Directness
- Blunt feedback is normal, not rude
- "How are you?" answered honestly
- Small talk less common than US/UK
- Saves time, don't take offense

### Punctuality
- Dutch are extremely punctual
- Arrive on time (or 5 min early)
- Being late is genuinely rude
- Appointments scheduled weeks ahead

### Cycling Etiquette
- Stay RIGHT on bike paths
- Signal turns with your arm
- Don't stop suddenly
- Don't walk in bike lanes (ever)
- Locals cycle fast and expect you to know rules

### Tipping
- Not expected, but appreciated
- **Restaurants**: Round up or 5-10%
- **Bars**: Round up to nearest euro
- **Taxis**: Round up
- **Hotels**: €1-2 for porter

### Quiet Hours
- Sundays traditionally quiet
- Many shops closed or open late
- Noise complaints taken seriously
- Respect residential areas evenings

## Safety & Practical

### General Safety
- Utrecht is very safe
- Normal urban precautions apply
- Bike theft is the main crime — lock properly
- Pickpockets rare but exist (tourist areas)

### Emergency Numbers
- **112**: All emergencies (EU standard)
- **0900-8844**: Non-emergency police
- English spoken by all dispatchers

### Pharmacies (Apotheek)
- Regular hours: 8:00-17:30 Mon-Fri
- Check "dienstapotheek" for after-hours
- Basic meds at drugstore (Etos, Kruidvat)
- Prescription required for most medication

### Healthcare
- **EHIC/GHIC**: EU citizens covered
- **Travel insurance**: Essential for non-EU
- **Huisarts**: GP, need referral for specialists
- **Hospital**: UMC Utrecht for emergencies

### Water
- Tap water excellent quality
- Free to ask for "kraanwater" at restaurants
- No need to buy bottled

## Best Times to Visit

### Peak Season (Apr-Sep)
- Best weather
- Outdoor terraces open
- Festival season
- Busier, slightly higher prices
- Book accommodation ahead

### Shoulder Season (Mar, Oct)
- Fewer crowds
- Variable weather
- Good deals
- Many attractions open

### Low Season (Nov-Feb)
- Cold, gray, rainy
- Fewer tourists
- Cozy "gezellig" atmosphere
- Christmas markets December
- Best hotel rates

### Special Events to Target
- **King's Day (April 27)**: Massive celebration, book way ahead
- **Festival Oude Muziek (Aug)**: Early music festival
- **Le Guess Who? (Nov)**: Alternative music festival
- **Nederlands Film Festival (Sep)**: Dutch film premieres

### Special Events to Avoid
- **King's Day**: Unless you want the chaos
- **Student week (Aug)**: Housing impossible
- **University graduation**: Hotels scarce

## Photography Tips

### Best Spots
1. Oudegracht from bridges (any bridge)
2. Dom Tower + square
3. Pandhof cloister
4. Twijnstraat (charming street)
5. Maliebaan (tree-lined avenue)

### Best Light
- Golden hour: Oudegracht glows
- Blue hour: Trajectum Lumen lights
- Rainy days: Reflections on canals

### Restrictions
- No drones without permit
- Ask before photographing people
- Some museums prohibit photos

## Connectivity

### WiFi
- Free in most cafes (ask for password)
- Station: NS Wifi available
- Hotels: Always included

### Mobile Data
- EU roaming: Use your home plan (EU citizens)
- Non-EU: Consider local SIM or eSIM
- Coverage: Excellent everywhere

### Useful Apps
- **NS**: Train schedules
- **9292**: All public transport
- **Buienradar**: Rain radar (essential)
- **Google Maps**: Works well for biking routes
- **TooGoodToGo**: Discount food
