# Utrecht — Attractions Guide

## Must-See (Don't Skip These)

### Dom Tower & Dom Square
The iconic 112m Gothic tower, tallest church tower in the Netherlands.
- **Duration**: 1-1.5 hours (guided climb, 465 steps)
- **Cost**: €15 adults
- **Tip**: Book online in advance, limited capacity
- **Dom Square**: Site where cathedral once connected to tower (collapsed 1674)
- **DOMunder**: Archaeological attraction beneath the square — Roman ruins, medieval graves

### Oudegracht (Old Canal)
Utrecht's defining feature: medieval canal with unique two-level wharf system.
- **Wharf cellars**: Now restaurants, bars, terraces at water level
- **Best section**: Between Oudaen and Stadhuisbrug
- **Activity**: Canal boat tour (€12-15) or rent a kayak/SUP
- **Evening**: Magical with lit terraces reflecting on water

### Museum Speelklok
Museum of self-playing musical instruments.
- **Why go**: Unique in Europe, enchanting guided tour with live demonstrations
- **Duration**: 1.5 hours
- **Cost**: €15
- **Family-friendly**: Excellent for children

### Centraal Museum
Utrecht's main art museum, excellent collection.
- **Highlights**: Gerrit Rietveld furniture, Dick Bruna (creator of Miffy), Utrecht Caravaggisti
- **Duration**: 2-3 hours
- **Cost**: €17.50
- **Don't miss**: Rietveld Schröder House (separate ticket, UNESCO World Heritage)

### Rietveld Schröder House
UNESCO World Heritage site. Iconic 1924 De Stijl architecture.
- **Must book**: Advance reservation required, small group tours only
- **Duration**: 1 hour
- **Cost**: €21 (includes Centraal Museum)
- **Why important**: Only building fully designed according to De Stijl principles

### Miffy Museum (Nijntje)
For families with young children (ages 2-6).
- **What it is**: Interactive museum based on Dick Bruna's creation
- **Duration**: 1.5-2 hours
- **Cost**: €11.50 (children), €3.50 (adults)
- **Note**: Best for toddlers, not older children

## Worth Visiting

### Railway Museum (Spoorwegmuseum)
Excellent museum covering Dutch rail history.
- **For**: Train enthusiasts, families
- **Duration**: 3-4 hours (large)
- **Cost**: €17.50
- **Highlight**: Historic trains, interactive exhibits, train rides

### Pandhof
Hidden medieval cloister garden behind the Dom Church.
- **Cost**: Free
- **Atmosphere**: Peaceful oasis in city center
- **Best time**: Spring/summer when flowers bloom
- **Note**: Often overlooked by tourists

### University Botanic Gardens
One of Europe's oldest botanical gardens (1639).
- **Two locations**: Original historic gardens + Fort Hoofddijk
- **Duration**: 1-2 hours
- **Cost**: €8.50
- **Best for**: Plant lovers, peaceful walk

### Trajectum Lumen
Nightly light art route through city center.
- **Cost**: Free
- **Duration**: 1-1.5 hours walking
- **How**: Follow route on trajectumlumen.com
- **Best**: After dark, year-round

### St. Martin's Cathedral (Domkerk)
Gothic church adjacent to Dom Tower.
- **Cost**: Free
- **Note**: Separated from tower since 1674 tornado collapsed nave
- **Interior**: Beautiful Gothic architecture, occasional organ concerts

## Overrated / Tourist Traps

### Canal "Cruise" boats (large tour boats)
- **Why skip**: Canals are narrow, small boats better. Walk instead.
- **Better**: Rent a sloep (small electric boat) with friends, or kayak

### Shopping streets (Oudegracht shops)
- **Why skip**: Generic chains, expensive. Same shops as any Dutch city.
- **Better**: Nachtegaalstraat, Voorstraat for unique shops

### Vredenburg Market (regular days)
- **Why skip**: Just a standard market on most days
- **Better**: Saturday morning for full market experience

## Day Trip Options

### Easy Day Trips from Utrecht

| Destination | Train Time | Why Go |
|-------------|------------|--------|
| Amsterdam | 25 min | Museums, canals, nightlife |
| Rotterdam | 40 min | Architecture, Markthal, harbor |
| Gouda | 20 min | Cheese market (Thu mornings Apr-Aug) |
| Amersfoort | 15 min | Medieval town, smaller crowds |
| 's-Hertogenbosch | 30 min | St. John's Cathedral, Bosch art |
| Kinderdijk | 1h + bus | UNESCO windmills (beautiful) |
| Giethoorn | 1.5h | "Venice of the North" (touristy but pretty) |
| The Hague | 40 min | Mauritshuis (Vermeer), peace palaces |

### Cycling Day Trips

| Route | Distance | Highlights |
|-------|----------|------------|
| Amelisweerd forest | 10km round | Beautiful forest east of city |
| Bunnik & Odijk | 15km round | Dutch countryside, orchards |
| Loosdrechtse Plassen | 25km round | Lakes, windmills |
| Wijk bij Duurstede | 30km round | Historic fortress town |

## Seasonal Highlights

### Spring (Mar-May)
- Keukenhof tulips (day trip, book ahead)
- King's Day (April 27) — massive orange street party
- Flower fields visible from train to Schiphol

### Summer (Jun-Aug)
- Festival season (Festival Oude Muziek, Le Guess Who?)
- Terrace season on Oudegracht
- Outdoor concerts in parks

### Fall (Sep-Nov)
- IMPAKT Festival (media art)
- Utrecht University academic year begins
- Autumn colors in parks

### Winter (Dec-Feb)
- Christmas markets (mid-December)
- Domtoren special illuminations
- Ice skating (if cold enough) at outdoor rinks
