# Utrecht — Visas & Work Permits

## Who Can Work in Netherlands

| Status | Work Rights | Notes |
|--------|-------------|-------|
| EU/EEA/Swiss | Full access | No permit needed |
| UK post-Brexit | Permit needed | Unless pre-Brexit resident |
| Non-EU skilled | HSM visa | Employer sponsors |
| Non-EU student | Limited hours | 16h/week or full-time summer |
| Non-EU partner | Usually yes | Depends on sponsor's status |

## EU/EEA Citizens

### No Permit Needed
If you're from EU, EEA, or Switzerland:
- Work freely
- Register at gemeente
- Get BSN
- Start working

### Still Need To
- Register within 4 months
- Get health insurance
- Pay taxes in NL

## Highly Skilled Migrant (HSM)

The main route for non-EU tech workers.

### Requirements

**Salary Thresholds (2026):**
| Age | Gross Monthly | Gross Annual |
|-----|---------------|--------------|
| Under 30 | €3,549 | €42,588 |
| 30+ | €4,840 | €58,080 |
| Recently graduated | €2,631 | €31,572 |

**Other Requirements:**
- Employer must be IND-recognized sponsor
- Valid passport
- No threat to public order
- Full-time employment (32+ hours)

### Process

| Step | Who | Time |
|------|-----|------|
| 1. Job offer | You + employer | Varies |
| 2. IND application | Employer submits | Same day |
| 3. Processing | IND | 2-4 weeks |
| 4. Pick up visa | You at embassy | 1-2 weeks |
| 5. Collect residence permit | You in NL | 2 weeks after arrival |

### Timeline
- Total: 4-8 weeks from application
- Can be faster for recognized sponsors
- Start date can be agreed in advance

### HSM Benefits
- Fast processing
- Family can join easily
- Path to permanent residence
- Can change employers (with new application)

### Recognized Sponsors
Most tech companies are registered. Check at:
ind.nl/en/public-register-recognised-sponsors

If company isn't registered, they must apply first (adds weeks).

## EU Blue Card

Alternative to HSM for highly qualified workers.

### Requirements
- Higher education degree (3+ years)
- Employment contract (1+ year)
- Salary: 1.5x average gross (≈€64,000/year)
- Employer in EU (doesn't need recognition)

### Pros
- Portable across EU after 18 months
- Family reunification easier
- Path to permanent residence

### Cons
- Higher salary requirement than HSM
- Less common in NL (HSM preferred)
- Slightly longer processing

### When to Use
- Very high salary already
- Plan to move within EU later
- Employer not IND-recognized

## 30% Ruling

Tax benefit for expats. Crucial for net income.

### What It Is
30% of your gross salary is tax-free. You pay income tax on remaining 70%.

### Eligibility
- Recruited from abroad (150+ km from NL border)
- Specific expertise (usually = salary threshold)
- Didn't live in NL for 16+ months before employment
- Apply within 4 months of starting

### Salary Threshold (2026)
- Under 30: €35,048 taxable (= €50,068 gross with ruling)
- 30+: €46,107 taxable (= €65,867 gross with ruling)
- Recently graduated: Different rules

### Impact Example

| Gross Annual | Without 30% | With 30% |
|--------------|-------------|----------|
| €60,000 | ~€38,000 net | ~€45,000 net |
| €80,000 | ~€48,000 net | ~€59,000 net |
| €100,000 | ~€58,000 net | ~€73,000 net |

### Duration
- Maximum 5 years
- Countdown starts at first eligible employment
- Cannot pause/restart

### Application
1. Employer and employee apply together
2. Via Belastingdienst
3. Within 4 months of start date
4. Retroactive if applied in time

### What It Covers
- Income tax reduction
- Tax-free reimbursements (school fees, relocation)
- Can choose partial non-resident tax status

### Warning
- If you leave NL and return, may not qualify again
- Job changes reset nothing — 5 years continues
- Employer must request (some forget)

## Orientation Year (Zoekjaar)

For recent graduates from Dutch universities or top global universities.

### Who Qualifies
- Graduated from Dutch higher education (last 3 years)
- OR graduated from top 200 global university (last 3 years)
- Under 30 (some flexibility)

### What You Get
- 1 year to find work in NL
- Can work any job during search
- Once employed: Switch to HSM

### How to Apply
- Apply to IND
- Proof of graduation
- Passport
- Fees: ~€210

## Startup Visa

For entrepreneurs starting a company in NL.

### Requirements
- Innovative product/service
- Facilitator (approved incubator) sponsors you
- Business plan
- Sufficient funds

### Facilitators in Utrecht
- UtrechtInc (primary option)
- Rockstart
- Others via IND list

### Process
1. Find facilitator
2. Facilitator applies to IND
3. 1-year residence permit
4. Can convert to self-employed or work visa

### Reality Check
- Competitive to get facilitator
- Must show innovation
- Not for lifestyle businesses
- Investor-trackable business preferred

## Self-Employed (ZZP)

Harder for non-EU nationals.

### Requirements
- Essential contribution to NL economy
- Business experience
- Sufficient income potential
- Often assessed via points system

### Point System Considers
- Education
- Experience
- Business plan viability
- Market need
- Investment

### Scoring
Need 90+ points from 300 possible. Difficult without strong profile.

### Alternatives
- Start as employee (HSM)
- Build business on side
- Switch to self-employed later
- Use startup visa if innovative

## Family Reunification

### Bringing Spouse/Partner

**If You're HSM:**
- Apply together or later
- Partner gets same permit duration
- Partner can work (any job)
- Joint application recommended

**Requirements:**
- Married or registered partnership, OR
- Proven relationship (cohabitation evidence)
- Sufficient income (salary threshold applies)
- Housing arrangement

### Bringing Children
- Under 18: Included in family application
- School enrollment straightforward
- Healthcare covered under your insurance

### Processing
- 2-4 weeks (recognized sponsor)
- Apply together when possible
- Partner can join before permit arrives (risk)

## Permanent Residence

### After 5 Years
Can apply for permanent residence (verblijfsvergunning onbepaalde tijd).

### Requirements
- 5 years legal residence
- Continuous (no gaps over 6 months)
- Integration exam passed (Inburgeringsexamen)
- Sufficient income
- No criminal record

### Integration Exam
- Dutch language (A2 level)
- Knowledge of Dutch society
- Can be waived with Dutch university degree

### Benefits
- No more renewals
- Work freely
- Stay regardless of employment
- Path to citizenship

## Dutch Citizenship

### After 5 Years
Can naturalize if:
- 5 years continuous residence
- Integration exam passed
- Renounce previous citizenship (most cases)
- No serious criminal record
- Current valid residence permit

### Dual Citizenship
Generally not allowed. Must renounce. Exceptions:
- Born in NL
- Married to Dutch national 3+ years
- Country doesn't allow renunciation
- Some specific cases

### Application
- Via gemeente
- Ceremony attendance required
- Fees: ~€1,000

## Common Mistakes

1. **Not applying for 30% ruling** — Huge money left on table
2. **Missing 4-month deadline** — For 30% ruling application
3. **Gaps in employment** — Can affect residence
4. **Assuming spouse can work** — Check specific permit
5. **Not registering at gemeente** — Blocks everything else
6. **Underestimating integration exam** — Start Dutch early

## Useful Contacts

| Service | Contact |
|---------|---------|
| IND (immigration) | ind.nl, 088-043 04 30 |
| IND appointment | ind.nl/en/appointment |
| 30% ruling | belastingdienst.nl |
| Gemeente Utrecht | utrecht.nl, 14 030 |

## Timeline Summary

| Visa Type | Processing | Total to Start |
|-----------|------------|----------------|
| HSM | 2-4 weeks | 4-8 weeks |
| EU Blue Card | 4-8 weeks | 6-12 weeks |
| Startup visa | 4-8 weeks | 8-16 weeks |
| Family reunion | 2-4 weeks | 4-8 weeks |

## Tips

1. **Get job first** — Much easier than other routes
2. **Recognized sponsor** — Check before accepting offer
3. **30% ruling in contract** — Have employer commit
4. **Start Dutch integration** — Even if not required yet
5. **Keep all documents** — Immigration loves paperwork
6. **Build timeline backward** — From desired start date
7. **Partner employment** — Verify their work rights
8. **Check latest thresholds** — Change yearly
