# Utrecht — Transport

## Overview

Utrecht is a cycling city. Within the city, bikes are fastest. For regional travel, trains are excellent. Cars are expensive and unnecessary.

| Mode | Best For |
|------|----------|
| Bicycle | Everything within Utrecht |
| Train (NS) | Other cities, Schiphol |
| Tram/Bus (U-OV) | Suburbs, bad weather |
| Car | Never (mostly) |

## OV-Chipkaart (Essential)

The universal Dutch transit card. Get one immediately.

### Types

| Type | Cost | Best For |
|------|------|----------|
| Anonymous | €7.50 | Tourists, occasional use |
| Personal | €7.50 | Residents, subscriptions |
| Disposable | €1 surcharge | Single trips |

### Where to Get
- NS ticket machines (Utrecht Centraal)
- Albert Heijn supermarkets
- Online: ov-chipkaart.nl (personal only)

### How It Works
1. Load credit (saldo) or subscription
2. Check in at start of journey
3. Check out at end
4. Forgetting checkout = max fare charged

### Loading Credit
- Minimum: €10
- Machines at stations
- Online (personal cards)
- Albert Heijn checkout

## Trains (NS)

### Utrecht Centraal
The Netherlands' busiest station. Your hub for:
- All major Dutch cities
- Schiphol Airport
- Regional trains

### Key Routes from Utrecht

| Destination | Time | Frequency | Single |
|-------------|------|-----------|--------|
| Amsterdam | 27 min | Every 10 min | €9.20 |
| Schiphol | 35 min | Every 15 min | €10.50 |
| Rotterdam | 38 min | Every 10 min | €13.10 |
| The Hague | 40 min | Every 15 min | €12.60 |
| Eindhoven | 45 min | Every 15 min | €21.50 |
| Maastricht | 2h | Every 30 min | €28.90 |

### Ticket Types

| Type | Price | Notes |
|------|-------|-------|
| Single (enkele reis) | Varies | One-way |
| Day return (dagretour) | +10-15% | Same day round trip |
| OV-chipkaart | -40% | With NS discount sub |
| Weekend free | €0 | With certain subscriptions |

### Subscriptions (Abonnementen)

| Subscription | Monthly | Benefit |
|--------------|---------|---------|
| NS Flex | €0-10 | Pay-per-use, small discount |
| Dal Vrij | €119 | Free off-peak travel |
| Altijd Vrij | €359 | Unlimited all trains |
| Traject Vrij | Varies | Fixed route free |

**Off-peak (Dal)**: Before 6:30, 9:00-16:00, after 18:30, weekends.

### Tips
- Buy via NS app (cheapest)
- Check-in/out on platform (not on train)
- Delays common — check ns.nl/reisinformatie
- Platform changes announced last-minute

## Tram & Bus (U-OV)

### Network
- **Tram**: 2 lines, center to suburbs
- **Bus**: Comprehensive city coverage
- **Regiobus**: Surrounding towns

### Fares (2026)

| Journey | Price |
|---------|-------|
| Single trip | €2-4 |
| 1-hour pass | €3.75 |
| Day pass | €8 |
| OV-chipkaart | Per km (€0.18) + base |

### Useful Lines

| Line | Route |
|------|-------|
| Tram 22 | Centraal → Science Park (Uithof) |
| Bus 8 | Centraal → Leidsche Rijn |
| Bus 28 | Centraal → Overvecht |
| Bus 12 | Centraal → Zuilen |

### Night Buses
Limited night service on weekends. Plan ahead or use bike/taxi.

### Tips
- Check in front door, out any door
- Drivers don't sell tickets — use OV-chipkaart
- Real-time info: u-ov.info app

## Cycling (Primary Transport)

See `cycling.md` for comprehensive guide.

### Quick Facts
- 60%+ of trips by bike
- Faster than any other mode within city
- World's largest bike parking at Centraal
- Mandatory lights after dark

### Getting a Bike

| Option | Cost |
|--------|------|
| Secondhand (Marktplaats) | €50-150 |
| Bike shop used | €100-250 |
| New basic | €300-500 |
| OV-fiets rental | €4.55/day |
| Swapfiets subscription | €19/month |

## OV-Fiets (Rental Bikes)

NS rental bikes at stations. Excellent for last-mile.

### How It Works
1. Need personal OV-chipkaart
2. Activate OV-fiets at ns.nl
3. Rent at any station
4. Return within 24 hours to any station
5. Cost: €4.55/day

### Locations in Utrecht
- Utrecht Centraal (huge facility)
- Utrecht Vaartsche Rijn
- Utrecht Overvecht
- Utrecht Zuilen

### Tips
- Return before 24h or charged double
- Check bike before riding
- Lock included
- Reserve via app in busy times

## Schiphol Airport Connection

### By Train (Recommended)
- Direct trains every 15 minutes
- Journey: 35-40 minutes
- Cost: €10.50 single
- Check-in at Utrecht Centraal, check-out at Schiphol

### Timeline for Flights
| Flight Type | Leave Utrecht |
|-------------|---------------|
| Domestic/EU | 2.5h before |
| Intercontinental | 3h before |
| Tight connection | Add buffer |

### Alternative: Eindhoven Airport
- Smaller, budget airlines (Ryanair, Wizz)
- 45 min train to Eindhoven + bus
- Sometimes cheaper flights

## Taxi & Rideshare

### Apps
- Uber (available but expensive)
- Bolt (slightly cheaper)
- Local taxi companies

### Typical Fares
| Route | Price |
|-------|-------|
| Centraal to center | €10-15 |
| Centraal to Leidsche Rijn | €20-25 |
| Centraal to Schiphol | €60-80 |

### When to Use
- Late night (no buses)
- Heavy luggage
- Groups (split cost)
- Bad weather emergency

## Car

### Why Not
- Parking expensive (€4-5/hour center)
- Many streets car-free
- Traffic limited
- Cycling faster for city trips
- High ownership costs

### If You Must
- Parking permits: €150-400/year (if available)
- Park & Ride facilities outside center
- Day trips: Consider car rental
- Supermarkets: Free parking usually

### Car Sharing
- Greenwheels
- Share Now
- Snappcar (peer-to-peer)
- Useful for occasional trips, IKEA runs

## Regional Connections

### Surrounding Towns

| Town | Connection | Time |
|------|------------|------|
| Zeist | Bus 50 | 20 min |
| Bilthoven | Train | 10 min |
| Nieuwegein | Tram 60 | 25 min |
| IJsselstein | Tram 60 | 30 min |
| Houten | Train | 10 min |
| Bunnik | Bus | 15 min |

### Day Trip Destinations

| Destination | Time | Transport |
|-------------|------|-----------|
| Amsterdam | 27 min | Train |
| Rotterdam | 38 min | Train |
| Kinderdijk | 1h | Train + bus |
| Gouda | 20 min | Train |
| Haarlem | 40 min | Train |
| Delft | 50 min | Train |
| Beach (Zandvoort) | 1h | Train |

## Transport Apps

| App | Purpose |
|-----|---------|
| NS | Train planning, tickets |
| 9292 | All public transport |
| U-OV | Local tram/bus |
| Google Maps | General navigation |
| Citymapper | Multi-modal planning |
| OV-fiets | Bike rental |

## Accessibility

### Wheelchair/Mobility
- Trains: Accessible, some assistance needed
- Trams: Low-floor, accessible
- Buses: Accessible
- Stations: Elevators available (check working status)

### Assistance
- NS assistance: Book via ns.nl/reizigerservice
- 24h notice recommended
- Available at Utrecht Centraal

## Money-Saving Tips

1. **Bike for everything local** (free after purchase)
2. **Dal Vrij subscription** if traveling off-peak
3. **NS Group tickets** for 4+ people
4. **Weekend deals** check ns.nl/weekendvoordeel
5. **OV-fiets** instead of taxi for station-to-destination
6. **9292.nl** to find cheapest routes
7. **Avoid single tickets** — OV-chipkaart always cheaper
