# Utrecht — Tech Industry

## Overview

Utrecht is the Netherlands' fourth tech hub after Amsterdam, Eindhoven, and Rotterdam. Smaller but growing, with strengths in gaming, health tech, and sustainability.

| Aspect | Reality |
|--------|---------|
| Size | Smaller than Amsterdam |
| Specialization | Gaming, health tech, sustainability |
| Talent | University pipeline strong |
| Startups | Growing scene, UtrechtInc hub |
| Remote | Many options |
| Salaries | 10-15% below Amsterdam |

## Tech Salaries (Feb 2026)

### Software Engineering

| Level | Gross Monthly | Gross Annual |
|-------|---------------|--------------|
| Junior (0-2y) | €3,500-4,500 | €42,000-54,000 |
| Mid (2-5y) | €4,500-6,000 | €54,000-72,000 |
| Senior (5+y) | €5,500-7,500 | €66,000-90,000 |
| Staff/Principal | €7,000-9,500 | €84,000-114,000 |
| Engineering Manager | €7,500-10,000 | €90,000-120,000 |

### Other Tech Roles

| Role | Gross Annual |
|------|--------------|
| Product Manager | €60,000-95,000 |
| UX Designer | €48,000-75,000 |
| Data Scientist | €55,000-85,000 |
| DevOps Engineer | €55,000-85,000 |
| QA Engineer | €45,000-65,000 |
| Tech Lead | €75,000-100,000 |
| CTO (startup) | €90,000-140,000 |

### Salary Notes
- Gross = before tax
- Net ≈ 55-65% of gross (depending on 30% ruling)
- Holiday allowance: +8% (paid in May)
- 13th month: Common in corporates
- Stock options: Rare outside startups

### 30% Ruling Impact

| Gross Annual | Without 30% | With 30% |
|--------------|-------------|----------|
| €60,000 | ~€3,200 net/mo | ~€3,800 net/mo |
| €80,000 | ~€4,000 net/mo | ~€4,900 net/mo |
| €100,000 | ~€4,800 net/mo | ~€6,100 net/mo |

The 30% ruling saves thousands per year. Fight for it.

## Major Employers

### Enterprise / Corporate

| Company | Sector | Employees |
|---------|--------|-----------|
| Rabobank | Banking | Tech hub in Utrecht |
| Eneco | Energy | Tech/digital teams |
| NS (Dutch Railways) | Transport | Large IT department |
| De Volksbank | Banking | HQ in Utrecht |
| KPN | Telecom | Various offices |
| Achmea | Insurance | Tech roles |

### Tech Companies

| Company | Focus | Notes |
|---------|-------|-------|
| Guerrilla Games | Gaming | PlayStation studio (Horizon) |
| Sticky Studios | Gaming | Mobile games |
| Yoast | WordPress/SEO | Remote-friendly |
| Channable | E-commerce feeds | Growing |
| Sendcloud | Shipping logistics | Scaling |
| MessageBird | Communications | Utrecht office |

### Health Tech

| Company | Focus |
|---------|-------|
| Luscii | Remote patient monitoring |
| Pacmed | Clinical decision support |
| ORTEC | Healthcare logistics |
| Aidence | Medical imaging AI |

### Consultancies

| Company | Type |
|---------|------|
| Accenture | Large consultancy |
| Capgemini | Large consultancy |
| Sogeti | Tech services |
| Ordina | Dutch IT services |
| Info Support | Tech training + services |

## Startup Scene

### UtrechtInc (Main Hub)
The city's primary startup incubator:
- Location: Science Park (Uithof)
- Programs: Acceleration, incubation
- Focus: Tech, health, sustainability
- Portfolio: 250+ startups
- Notable: Channable, Peerby originated here

### Other Incubators

| Name | Focus |
|------|-------|
| RIVM Innovation Hub | Health |
| Energy Innovation Lab | Sustainability |
| Creative Lab Utrecht | Creative industries |
| Utrecht Health Hub | Healthcare |

### Startup Funding
- Seed: €50k-500k typical
- Series A: €1-5M
- Later stages: Often move to Amsterdam
- Investors: Rockstart, Peak Capital, local angels

## Coworking Spaces

| Space | Location | Price/month |
|-------|----------|-------------|
| Spaces | Multiple | €300-500 |
| Tribes | City center | €250-400 |
| De Vasim | Lombok | €200-350 |
| Seats2Meet | Station area | Pay-per-use |
| Creative Labs | Various | €150-300 |

## University Connection

### Utrecht University
- 30,000+ students
- Strong CS, AI, Data Science programs
- Research partnerships with industry
- Talent pipeline for tech companies

### Key Research Areas
- AI and machine learning
- Complex systems
- Computational biology
- Game technology

### Hogeschool Utrecht
- Applied sciences focus
- IT, media programs
- Industry-focused curriculum
- Internship connections

## Finding Tech Jobs

### Platforms

| Platform | Type |
|----------|------|
| LinkedIn | Universal |
| Indeed.nl | General Dutch |
| Honeypot | Reverse recruiting |
| AngelList | Startups |
| Stack Overflow Jobs | Developer-focused |
| Working at NL | Dutch companies |

### Direct Applications
Many Dutch companies prefer direct applications:
1. Find company website
2. Check careers page
3. Apply directly (often via Greenhouse, Lever)

### Recruiters
- Active in Netherlands
- IT recruitment agencies many
- Be selective — spam common
- Good ones: Brunel, Huxley, Michael Page

### Networking

| Event | Type |
|-------|------|
| Meetup.com groups | Various tech topics |
| Utrecht Data Science meetup | Monthly |
| DevOps Utrecht | Regular events |
| Startup Grind Utrecht | Entrepreneur networking |

## Work Culture

### Dutch Tech Culture
- Flat hierarchies (really flat)
- Direct communication
- Work-life balance sacred
- Part-time accepted
- Home office common
- Results over hours

### Standard Benefits
- 25-30 vacation days
- Pension contribution (employer pays most)
- Travel allowance or NS subscription
- Training budget often
- Lunch (sometimes)
- Home office allowance

### Work Hours
- 40h/week standard
- 36h not uncommon
- Part-time (32h) acceptable
- Overtime rare and compensated
- Fridays often half-day

### Remote Work
- Very common post-COVID
- Hybrid most common (2-3 office days)
- Fully remote possible for some
- Remote roles often Amsterdam-salary

## Gaming Industry

Utrecht has a notable gaming cluster:

### Studios

| Studio | Known For |
|--------|-----------|
| Guerrilla Games | Horizon series (AAA) |
| Sticky Studios | Mobile games |
| Abbey Games | Reus, Godhood |
| Paladin Studios | Mobile games |

### Gaming Jobs
- More competitive than enterprise
- Passion expected
- Portfolio matters
- Specialization valued
- Crunch exists (less than US)

## Health Tech Hub

Utrecht has strong healthcare connections:

### Why Utrecht
- UMC Utrecht (university hospital)
- RIVM (national health institute)
- Multiple hospitals
- Research infrastructure

### Opportunities
- Medical device software
- Health data platforms
- AI diagnostics
- Patient engagement
- Clinical trial systems

## Visa & Work Permits

See `visas.md` for full details.

### Quick Summary
- **EU citizens**: No permit needed
- **Non-EU skilled**: Highly Skilled Migrant visa
- **Salary threshold (2026)**: €46,107/year (under 30) or €63,440 (30+)
- **30% ruling**: Apply via employer
- **Timeline**: 2-4 weeks typical

## Tech Meetups

### Regular Events

| Event | Frequency | Topic |
|-------|-----------|-------|
| Utrecht.py | Monthly | Python |
| JS Utrecht | Monthly | JavaScript |
| DevOps Utrecht | Monthly | DevOps |
| Data Science Utrecht | Monthly | Data/ML |
| UX Utrecht | Irregular | Design |

### Conferences
- Most major ones in Amsterdam
- Utrecht hosts smaller events
- University hosts academic conferences

## Career Growth

### In Utrecht
- Fewer senior roles than Amsterdam
- Many max out and move to AMS
- Startup→corporate common path
- Consulting good for variety

### Remote Strategy
- Work remote for Amsterdam company
- Higher salary, Utrecht living
- Increasingly common
- Full-time remote in demand

### International Companies
- Many have Amsterdam offices, not Utrecht
- Remote roles available
- Commute to Amsterdam: 30 min train

## Tips

1. **30% ruling is crucial** — significant net income difference
2. **Dutch helps but not required** — tech is English-first
3. **Network actively** — Dutch hire through connections
4. **Start with startups** — easier entry, faster growth
5. **Consider hybrid** — Utrecht living + Amsterdam salary
6. **University events** — good for networking
7. **Gaming is competitive** — need portfolio/experience
8. **Health tech growing** — good entry point
