# Utrecht — Startup Ecosystem

## Overview

Utrecht's startup scene is smaller than Amsterdam but growing. Strengths in health tech, gaming, sustainability, and enterprise SaaS.

| Aspect | Reality |
|--------|---------|
| Size | Smaller than AMS, growing |
| Strengths | Health tech, gaming, sustainability |
| Funding | Seed strong, later stages harder |
| Talent | University pipeline excellent |
| Cost | Cheaper than Amsterdam |
| Exit culture | Developing |

## UtrechtInc (Main Hub)

The primary startup incubator and accelerator.

### Location
Science Park (Uithof), near Utrecht University

### Programs

| Program | Duration | For |
|---------|----------|-----|
| Incubation | 6-18 months | Early-stage startups |
| Acceleration | 3-6 months | Growth-ready startups |
| Pre-incubation | 3 months | Idea validation |
| Student programs | Varies | University students |

### What You Get
- Workspace
- Mentorship
- Network access
- Investor introductions
- Workshops and training
- Peer community

### Costs
- Subsidized rates
- Often equity-free
- ~€100-300/month for desk

### Selection
- Application process
- Pitch to committee
- Focus on team, problem, solution
- Tech/innovation focus preferred

### Notable Alumni
- Channable (e-commerce feed management)
- Peerby (sharing economy)
- Various health tech companies

## Other Incubators/Accelerators

### Utrecht Region

| Organization | Focus |
|--------------|-------|
| Rockstart | Energy, health (some Utrecht activity) |
| Utrecht Health Hub | Healthcare innovation |
| RIVM Innovation | Health/government tech |
| HKU programs | Creative industries |
| Hogeschool Utrecht | Applied innovation |

### Consider Amsterdam
Many founders base in Utrecht, join Amsterdam programs:
- Startupbootcamp
- Rockstart main programs
- B Startup School
- ACE Venture Lab

30-minute train = easy access.

## Funding Landscape

### Pre-Seed (€10k-100k)

| Source | Notes |
|--------|-------|
| Friends & family | Traditional |
| Government grants | See below |
| Angel investors | UBAN, local angels |
| Incubator prizes | UtrechtInc competitions |

### Seed (€100k-1M)

| Investor | Focus |
|----------|-------|
| Peak Capital | Various |
| Borski Fund | B2B SaaS |
| henQ | Enterprise |
| Innovation Industries | Deep tech |
| Local angels | Various |

### Series A+ (€1M+)

| Investor | Focus |
|----------|-------|
| Inkef Capital | Health tech |
| Newion | B2B tech |
| Prime Ventures | Growth stage |
| HPE Growth | Scale-ups |

**Reality:** Series A+ often requires Amsterdam presence or international focus.

## Government Grants

### WBSO (R&D Tax Credit)
- Reduces wage tax for R&D activities
- Up to 32% of R&D wages
- Apply via rvo.nl
- Most tech startups eligible

### MIT (SME Innovation)
- Feasibility studies: Up to €20,000
- R&D collaboration: Up to €200,000
- Via rvo.nl

### Innovatiekrediet
- Loan for technical development
- Up to €5 million
- Higher risk tolerance than banks
- Partial forgiveness if project fails

### Regional Subsidies
- Utrecht region has various programs
- Check rom-utrecht.nl
- Innovation vouchers
- Export support

### EU Funding
- Horizon Europe (complex but large)
- EIC Accelerator (up to €2.5M grant + €15M equity)
- Requires significant effort

## Angel Investors

### Utrecht Business Angel Network (UBAN)
- Local angel group
- Regular pitch events
- Investment: €25k-200k typically
- Also provide mentorship

### Finding Angels
- UtrechtInc introductions
- Leapfunder platform
- Personal networking
- LinkedIn outreach
- Startup events

### What Angels Want
- Strong team
- Clear problem/solution
- Some traction
- Reasonable valuation
- Exit potential

## Startup Support

### Free Resources

| Resource | What |
|----------|------|
| KvK | Business registration, basic advice |
| RVO | Innovation funding info |
| UtrechtInc open events | Networking, learning |
| Meetup groups | Peer learning |
| University resources | If affiliated |

### Paid Services

| Service | Cost |
|---------|------|
| Lawyer (startup-focused) | €150-300/hour |
| Accountant | €100-200/hour |
| HR/payroll | €50-150/employee/month |
| IP attorney | €200-400/hour |

### Startup-Friendly Lawyers
Several firms specialize in startups:
- Fixed-fee packages common
- Equity payment sometimes possible
- Look for experience with VC terms

## Building Your Team

### Finding Tech Talent

| Source | Notes |
|--------|-------|
| Utrecht University | CS, AI students |
| Hogeschool Utrecht | Applied tech |
| LinkedIn | Most common |
| Meetups | Developer communities |
| UtrechtInc network | Fellow startups |
| Remote | International talent |

### Salary Expectations

| Role | Early Stage | Funded |
|------|-------------|--------|
| Junior dev | €35-45k | €40-50k |
| Senior dev | €50-65k | €60-80k |
| First employee | Often equity-heavy | Market rate |

### Equity Compensation
- Common for early employees
- STAK structure (Dutch-friendly)
- Vesting: 4 years typical
- Cliff: 1 year typical

### Hiring Reality
- Competition with corporates
- Mission/equity matters for startups
- Remote can expand pool
- Amsterdam talent commutes

## Coworking for Startups

| Space | Price/month | Notes |
|-------|-------------|-------|
| UtrechtInc | €100-300 | Best for incubated |
| Seats2Meet | Pay-per-use | Flexible |
| De Vasim | €200-350 | Creative vibe |
| Spaces | €300-500 | Professional |
| Tribes | €250-400 | Growing companies |

## Networking Events

### Regular Events

| Event | Frequency | Format |
|-------|-----------|--------|
| UtrechtInc Demo Days | Quarterly | Startup pitches |
| Startup Grind Utrecht | Monthly | Fireside chats |
| Local meetups | Weekly | Topic-specific |
| Founder drinks | Irregular | Casual networking |

### Major Events
- Dutch Startup Days (national)
- TNW Conference (Amsterdam)
- University demo days
- Health tech events

### Online Communities
- Startup Utrecht Slack
- Dutch Startup Jobs (Facebook)
- LinkedIn groups
- Twitter/X startup community

## Health Tech Opportunity

Utrecht has unique health tech advantages:

### Why Utrecht

| Asset | Value |
|-------|-------|
| UMC Utrecht | Major university hospital |
| RIVM | National health institute |
| Utrecht Life Sciences | Network |
| Research infrastructure | Clinical trials, data |

### Health Tech Focus Areas
- Medical devices + software
- Digital therapeutics
- AI diagnostics
- Patient engagement
- Healthcare logistics
- Clinical decision support

### Getting Started
- Utrecht Health Hub
- UMC innovation department
- Health Valley network

## From Idea to Launch

### Typical Timeline

| Phase | Duration | Focus |
|-------|----------|-------|
| Validation | 1-3 months | Problem/solution fit |
| MVP | 2-4 months | Build minimum product |
| Early customers | 3-6 months | Prove traction |
| Seed funding | 2-4 months | If needed |
| Scale | Ongoing | Growth |

### Cost to Start

| Item | Range |
|------|-------|
| Legal setup (BV) | €1,000-2,000 |
| MVP development | €0-50,000 |
| Coworking (6 months) | €600-3,000 |
| Tools & software | €200-500/month |
| Marketing initial | €1,000-5,000 |
| Buffer/runway | €10,000+ |

### Bootstrap vs. Funding
- Bootstrap: Longer runway, full control
- Seed: Faster growth, dilution
- Many Dutch startups bootstrap longer
- Funding culture less aggressive than US

## Legal Considerations

### Company Structure
- BV (private limited) for investment
- Start Eenmanszaak, convert later (some do)
- Holding structure for tax efficiency

### IP Protection
- Patents for novel inventions
- Trademarks for brand
- Trade secrets (practical for software)
- Consider before publishing/pitching

### Contracts Needed
- Founder agreement
- Employee contracts
- IP assignment
- NDA (use sparingly)
- Terms of service
- Privacy policy

## Common Mistakes

1. **Building before validating** — Talk to customers first
2. **Raising too early** — Dilution at low valuation
3. **Ignoring grants** — Free money available
4. **Solo founding** — VCs prefer teams
5. **Amsterdam envy** — Utrecht has real advantages
6. **Overcomplicating legal** — Start simple, scale later
7. **Not networking** — Dutch business is relationship-heavy

## Utrecht Advantages

- **Cheaper than Amsterdam** — Lower runway burn
- **University talent** — Direct pipeline
- **Health tech cluster** — Real competitive advantage
- **Quality of life** — Team retention easier
- **Less competition** — For talent, attention
- **Central location** — Easy access to everywhere

## Tips

1. **Join UtrechtInc** — Even if just events
2. **Apply for grants early** — Long processing times
3. **Build in public** — LinkedIn, Twitter presence
4. **Connect with university** — Student projects, research
5. **Health tech opportunity** — If relevant, pursue it
6. **Amsterdam hybrid** — Utrecht living, AMS networking
7. **Founder community** — Share struggles, learn faster
8. **Start Dutch early** — Opens doors long-term
