# Utrecht — Safety & Laws

## Safety Overview

Utrecht is one of the safest cities in Europe. Violent crime is rare. Most issues are petty theft and bike-related.

| Risk | Level | Notes |
|------|-------|-------|
| Violent crime | Very low | Rare, avoid late-night conflicts |
| Pickpocketing | Low-medium | Tourist areas, station |
| Bike theft | High | Two locks essential |
| Scams | Low | Housing scams exist |
| Traffic | Medium | Bikes have right-of-way |

## Emergency Numbers

| Service | Number |
|---------|--------|
| All emergencies | 112 |
| Police (non-emergency) | 0900-8844 |
| Ambulance (non-emergency) | Local hospital |
| Fire (non-emergency) | 0900-0904 |
| Poison control | 030-274 8888 |
| Tourist assistance | 14 030 |

### 112 Guidelines
- Free from any phone
- Works without SIM
- English operators available
- Give location first
- Stay on line

## Police

### Reporting Crime
- **Emergency**: 112
- **Non-emergency**: 0900-8844 or police.nl
- **In person**: Politiebureau Utrecht (multiple locations)

### What to Report
- All theft (for insurance)
- Assault or threats
- Traffic accidents
- Suspicious activity
- Lost documents

### Police Stations

| Location | Address |
|----------|---------|
| Centrum | Kroonstraat 25 |
| Overvecht | Tiberdreef 10 |
| Leidsche Rijn | Verlengde Hoogravenseweg |

## Crime Types

### Bike Theft
The main crime you'll encounter.

**Prevention:**
- Two locks (one through frame)
- Never leave unlocked, even briefly
- Use designated bike parking
- Cheap bike = less target
- Register at fietsregistratie.nl

**If Stolen:**
- Report at police.nl (for insurance)
- Check Marktplaats (bikes often resold)
- Insurance claim if covered

### Pickpocketing
Mostly at:
- Utrecht Centraal (crowds)
- Tourist attractions
- Events and festivals

**Prevention:**
- Front pockets for valuables
- Bag zipped and in front
- Don't flash expensive items
- Be aware in crowds

### Housing Scams
Common trap for newcomers.

**Red Flags:**
- Rent too good to be true
- Payment before viewing
- Owner "abroad" — can't meet
- Western Union / crypto payment
- No viewing possible
- Fake agency names

**Safety:**
- Always view in person
- Verify ownership (Kadaster)
- Never pay before contract
- Use known platforms

## Laws You Must Know

### Identification
- Must carry ID if 14+ years old
- Passport or EU ID card
- Copy on phone not accepted
- Fine: €95 if unable to identify

### Drugs

| Substance | Status | Penalty |
|-----------|--------|---------|
| Cannabis (small amount) | Tolerated | Coffeeshops only, not public |
| Cannabis (public use) | Fine | €100+ |
| Hard drugs | Illegal | Criminal charges |
| Drug dealing | Illegal | Serious charges |

**Utrecht Reality:**
- Few coffeeshops compared to Amsterdam
- No public consumption
- Zero tolerance in most areas
- Police do enforce

### Alcohol
- Legal age: 18
- Public intoxication: Fined
- Open containers: Some areas prohibited
- Driving limit: 0.5‰ (0.2‰ new drivers)

### Cycling Violations

| Violation | Fine |
|-----------|------|
| No lights | €55 |
| Phone use | €140 |
| Red light | €110 |
| Wrong way | €95 |
| No bell | €40 |
| Drunk cycling | €100+ |

Fines enforced. Police conduct regular checks.

### Noise
- Strict regulations in residential areas
- Neighbors will complain (and report)
- Music after 22:00: Keep low
- Construction: Weekdays only, limited hours

### Renting Violations
- Subletting without permission: Eviction risk
- More occupants than registered: Illegal
- Running business from residential: May need permit
- Airbnb without license: Heavy fines

## Neighborhood Safety

### Generally Safe
All Utrecht neighborhoods are safe by day. Some variation at night:

| Area | Day | Night |
|------|-----|-------|
| City Center | Very safe | Safe (some drunk tourists) |
| Lombok | Safe | Safe |
| Wittevrouwen | Very safe | Very safe |
| Tuindorp | Very safe | Very safe |
| Leidsche Rijn | Safe | Safe |
| Overvecht | Safe | Some caution |
| Station area | Safe | Moderate caution |

### Late Night Tips
- Stick to lit streets
- Avoid confrontations
- Don't engage with aggressive behavior
- Use well-traveled routes

## Traffic Safety

### As a Cyclist
- Assume cars don't see you
- Use lights at night (mandatory)
- Signal turns with hand
- Watch for car doors
- Tram tracks are slippery
- Right has priority at unmarked crossings

### As a Pedestrian
- Look for bikes first, then cars
- Don't walk in bike lanes
- Cyclists won't stop for you
- Cross at designated areas

### As a Driver
- Bikes have right-of-way often
- Check mirrors constantly
- Speed limits enforced strictly
- Parking violations expensive

## Healthcare Emergencies

### Life-Threatening
- Call 112
- Nearest hospital: UMC Utrecht, Heidelberglaan 100

### Urgent (Not Emergency)
- Huisartsenpost (after-hours GP): 0900-3336333
- Go to designated location
- Bring ID and insurance card

### Pharmacy (Apotheek)
- Regular hours: Most pharmacies
- After hours: Dienstapotheek (rotating)
- Check: apotheek.nl for current duty pharmacy

## Natural Hazards

### Weather-Related
- Ice: Cycling dangerous in winter
- Wind: Strong gusts, secure belongings
- Rain: Constant, dress for it
- Heat waves: Rare but increasing

### Flooding
- Utrecht generally safe
- Low risk compared to coastal areas
- Follow official warnings if issued

## Legal Rights

### If Stopped by Police
- Must show ID
- Can remain silent on other questions
- Right to lawyer if arrested
- Right to interpreter
- Can refuse search (they may do anyway)

### If Arrested
- Call embassy
- Request lawyer
- Don't sign what you don't understand
- You have rights — use them

### Tenant Rights
- Strong protections in Netherlands
- Eviction requires court order
- Rent increases regulated
- Deposit must be returned
- Document apartment condition at move-in

## Scam Awareness

### Common Scams
- Fake housing listings
- Too-good job offers
- "You hit my car" claims
- Fake police (asking for money)
- Online marketplace fraud

### Protection
- If it's too good: It's fake
- Never pay upfront for housing
- Verify before sending money
- Meet in public for marketplace deals
- Trust your instincts

## Women's Safety

Utrecht is very safe for women:
- Walking alone at night: Generally fine
- Public transport: Safe
- Harassment: Rare, but report if occurs

### Resources
- Veilig Thuis (domestic issues): 0800-2000
- Centrum Seksueel Geweld: 0800-0188

## LGBTQ+ Safety

Netherlands was first country to legalize same-sex marriage. Utrecht is very accepting:
- Open LGBTQ+ community
- Pride events
- Anti-discrimination laws strong
- Report hate crimes: 0900-8844

## Practical Security

### Home Security
- Door: Multiple locks common
- Windows: Close when out
- Packages: Use pickup points
- Neighbors: Building community helps

### Digital Security
- Public WiFi: Use VPN
- Banking: Strong authentication
- Documents: Don't carry unnecessarily
- Copies: Keep digital copies of ID

## Key Takeaways

1. **Utrecht is safe** — Don't be paranoid
2. **Lock your bike properly** — Main theft risk
3. **Carry ID** — It's the law
4. **Know cycling rules** — Fines are real
5. **Trust your instincts** — If something feels wrong, leave
6. **Report crimes** — Even minor, for statistics and insurance
