# Utrecht — Moving & Settling

## First Steps Timeline

| Week | Tasks |
|------|-------|
| Before arrival | Secure housing (critical), gather documents |
| Week 1 | Register at gemeente, open bank account |
| Week 2 | Get BSN, apply for health insurance |
| Week 3 | Set up DigiD, register with GP |
| Week 4 | Get bike, explore neighborhoods |

## Housing First (Non-Negotiable)

You **cannot** register without a valid address. No registration = no BSN = no bank = no job.

### Required for Registration
- Rental contract with your name
- Landlord permission (verhuurder verklaring)
- Property must allow registration (some rooms don't)

### Warning Signs
- "No registration possible" = illegal sublet or anti-squat
- Short-term rental only = won't work for BSN
- Hotel address = rejected

### Finding Housing
| Platform | Type |
|----------|------|
| Funda.nl | Premium rentals |
| Pararius.com | Expat-focused |
| Kamernet.nl | Rooms/studios |
| Facebook groups | Utrecht Expats Housing |
| Housing agencies | Expensive but effective |

Budget: 1-2 months searching minimum. Start before moving.

## Municipality Registration (Gemeente)

### Where
**Stadskantoor Utrecht**
- Address: Stadsplateau 1, 3521 AZ
- Near Utrecht Centraal
- Appointment required: utrecht.nl/afspraak

### Documents Needed
- Valid passport
- Birth certificate (apostilled)
- Rental contract
- Verhuurder verklaring (landlord declaration)
- Marriage certificate if applicable
- €25-50 fee

### What Happens
1. Book appointment online (2-4 weeks wait)
2. Bring all documents
3. Receive confirmation letter
4. BSN arrives by mail (1-2 weeks)

### Common Rejections
- Missing landlord declaration
- Address not registered as residential
- Documents not apostilled/legalized

## BSN (Citizen Service Number)

Your BSN is essential for:
- Opening bank account
- Getting health insurance
- Starting employment
- Tax registration
- Accessing government services

### Timeline
- Applied for: During gemeente registration
- Received: 1-2 weeks by post
- Format: 9-digit number
- Keep it: You'll need it constantly

## Bank Account

### Requirements
- BSN (usually)
- Passport
- Proof of address
- Dutch phone number helps

### Banks Accepting Expats

| Bank | BSN Required | Notes |
|------|--------------|-------|
| ING | No (but soon after) | Expat-friendly |
| ABN AMRO | Yes | Good English service |
| Rabobank | Yes | Local presence |
| Bunq | No | Digital-first, fast setup |
| Revolut | No | Good interim solution |

### Strategy
1. Open Bunq/Revolut immediately (no BSN needed)
2. Use for first expenses
3. Open Dutch bank after BSN
4. Dutch bank needed for salary, rent, subscriptions

### Costs
- Account fees: €0-5/month
- Debit card: Usually included
- iDEAL: Essential for Dutch payments

## Health Insurance (Mandatory)

### Timeline
- Must have within 4 months of registration
- Start date: Date of registration
- Penalty: €455 + forced enrollment

### Basic Insurance (Basisverzekering)
- Cost: €130-160/month
- Covers: GP, hospital, most medications
- Required by law

### Providers
| Provider | Price Range | Notes |
|----------|-------------|-------|
| Zilveren Kruis | €130-145 | Largest provider |
| CZ | €130-140 | Good service |
| VGZ | €135-150 | Regional strength |
| OHRA | €125-135 | Budget option |

### Compare at
- independer.nl
- zorgwijzer.nl

### What's Covered
- GP visits (free)
- Hospital (after deductible)
- Prescriptions (mostly)
- Maternity care
- Mental health (limited)

### Not Covered (Add-ons Needed)
- Dental (except emergencies)
- Physiotherapy
- Glasses/contacts
- Alternative medicine

## Finding a GP (Huisarts)

### Why It Matters
- Gatekeeper system: GP refers to specialists
- No direct specialist access
- Must register with one practice

### How to Find
1. Search: zorgkaartnederland.nl
2. Call practices near you
3. Many have waiting lists
4. Ask if accepting new patients

### Registration
- Bring ID, insurance card, BSN
- Fill out intake form
- May have brief appointment

### Common Issue
Many practices full. Start searching early. Some expat-focused practices exist.

## DigiD

Digital identity for government services.

### What You Need It For
- Tax returns (Belastingdienst)
- Health insurance subsidies (zorgtoeslag)
- Childcare subsidies
- Municipal services
- Many official applications

### How to Get
1. Go to digid.nl/aanvragen
2. Enter BSN and personal details
3. Receive activation code by post (1 week)
4. Activate online
5. Set up 2FA (SMS or app)

### Timeline
- Application: 5 minutes
- Letter arrival: 5-10 days
- Activation: Same day as letter

## Phone & Internet

### Mobile Options

| Provider | Monthly | Notes |
|----------|---------|-------|
| KPN | €15-40 | Major carrier |
| Vodafone | €15-35 | Good coverage |
| T-Mobile | €15-35 | Competitive |
| Simyo | €10-25 | Budget (KPN network) |
| Ben | €10-20 | Budget option |

### Prepaid vs Contract
- Prepaid: No BSN needed, higher per-unit cost
- Contract: Needs BSN/bank, better value

### Home Internet
- Providers: KPN, Ziggo, T-Mobile
- Cost: €35-55/month
- Speed: 100-1000 Mbps available

## Utilities Setup

### Electricity & Gas
- Compare at: independer.nl, energievergelijk.nl
- Providers: Vattenfall, Eneco, Essent, Budget Energie
- Contract: Fixed or variable rate
- Smart meter: Usually installed

### Water
- Provider: Waterbedrijf Vitens (monopoly)
- Auto-enrolled at your address
- Cost: €15-25/month

### Municipal Taxes
- Annual taxes for waste, water authority
- Bills arrive yearly
- Can pay monthly
- €300-600/year typical

## Documents Checklist

### Bring from Home Country
- [ ] Passport (valid 6+ months)
- [ ] Birth certificate (apostilled)
- [ ] Marriage certificate if married (apostilled)
- [ ] University degrees (for 30% ruling)
- [ ] Employment contract
- [ ] Reference letters from previous landlords
- [ ] Proof of income/savings

### Apostille
Most documents need apostille (international certification):
- Obtain from your home country
- Before you move
- Some need translation to Dutch/English

## Key Contacts

| Service | Contact |
|---------|---------|
| Municipality | 14 030 |
| Police (non-emergency) | 0900-8844 |
| Health insurance info | 0800-0087 |
| DigiD helpdesk | 088-153 65 35 |
| IND (immigration) | 088-043 04 30 |

## First Month Budget

| Item | Cost |
|------|------|
| Deposit (rent) | €2,000-4,000 |
| First month rent | €1,200-1,800 |
| Furniture basics | €500-1,500 |
| Bike | €100-300 |
| Health insurance | €130-160 |
| Groceries setup | €100-150 |
| Phone/internet | €50-100 |
| **Total** | **€4,000-8,000** |

Have this available in cash/accessible accounts before arriving.
