# Utrecht — Local Services

## Essential Services Overview

| Service | Provider | Notes |
|---------|----------|-------|
| Municipality | Gemeente Utrecht | Main government contact |
| Identity | BSN via gemeente | Required for everything |
| Digital ID | DigiD | Online government access |
| Banking | ING, ABN AMRO, Rabobank | Dutch account needed |
| Tax | Belastingdienst | Annual returns required |
| Healthcare | Zorgverzekering | Mandatory insurance |

## BSN (Citizen Service Number)

The Dutch equivalent of social security number. You need it for everything.

### What It Unlocks
- Bank account opening
- Employment contracts
- Health insurance
- Tax registration
- Government services
- Phone contracts (sometimes)

### How to Get
1. Register at gemeente (see `resident.md`)
2. Receive BSN in registration letter
3. Arrives 1-2 weeks after registration

### If You Lose It
- Check old documents (tax returns, insurance)
- Request at gemeente (with ID)
- Part of BRP (population register)

## DigiD

Your digital identity for government services.

### What You Need It For
- Tax returns (Belastingdienst)
- Subsidies (toeslagen)
- Municipal services
- Healthcare portal
- Pension information
- Student finance (DUO)

### Setup Process
1. Go to digid.nl/aanvragen
2. Enter BSN and personal details
3. Wait for activation letter (1 week)
4. Activate online with code
5. Set up 2FA (SMS or DigiD app)

### Security Levels
| Level | Method | Access |
|-------|--------|--------|
| Basic | Password | Limited services |
| Middle | SMS verification | Most services |
| High | DigiD app | All services |

### Recommendation
Use DigiD app — most secure, required for some services.

## Banking

### Major Banks

| Bank | Branches | Expat-Friendly | Monthly Fee |
|------|----------|----------------|-------------|
| ING | Many | Very | €0-5 |
| ABN AMRO | Many | Good | €0-5 |
| Rabobank | Many | Good | €0-5 |
| SNS | Some | Moderate | €0-3 |
| ASN | Few | Moderate | €0-3 |

### Digital Banks

| Bank | BSN Required | Notes |
|------|--------------|-------|
| Bunq | No | Good interim solution |
| N26 | No | German, works in NL |
| Revolut | No | Good for transition |

### Opening Account

**Requirements:**
- BSN (for most Dutch banks)
- Passport/ID
- Proof of address
- Dutch phone number

**Timeline:**
- Application: 15-30 minutes
- Card arrival: 3-7 days
- Full activation: 1-2 weeks

### iDEAL
Dutch payment system. Essential for:
- Online shopping
- Bills
- Government payments
- Many subscriptions

Every Dutch bank account includes iDEAL.

### Cash
Increasingly unnecessary but:
- Markets often cash-only
- Small cafés sometimes
- Keep some for emergencies
- ATMs (geldautomaat) widespread

## Taxes (Belastingdienst)

### Tax Return
- Annual filing required
- Deadline: May 1 (for previous year)
- File via DigiD at belastingdienst.nl
- Refund or payment calculated automatically

### Key Taxes

| Tax | Rate | Notes |
|-----|------|-------|
| Income (Box 1) | 36.97% / 49.5% | Progressive |
| Savings (Box 3) | ~1.2% | On assets above €57,000 |
| BTW (VAT) | 21% / 9% | Included in prices |

### 30% Ruling
Tax benefit for skilled migrants:
- 30% of salary tax-free
- Significant savings
- Requires application via employer
- Max 5 years (recent rules)
- See `visas.md` for details

### Subsidies (Toeslagen)

| Subsidy | For | Application |
|---------|-----|-------------|
| Zorgtoeslag | Health insurance | Belastingdienst |
| Huurtoeslag | Rent | Belastingdienst |
| Kinderopvangtoeslag | Childcare | Belastingdienst |
| Kinderbijslag | Child benefit | SVB |

Apply via DigiD. Income-dependent.

## Municipal Services

### Gemeente Utrecht
- Address: Stadskantoor, Stadsplateau 1
- Website: utrecht.nl
- Phone: 14 030

### Services Available

| Service | How |
|---------|-----|
| Registration | Appointment |
| ID documents | Appointment |
| Birth registration | Within 3 days |
| Marriage | Book months ahead |
| Parking permits | Online |
| Waste passes | Online |

### Appointment Booking
- Online: utrecht.nl/afspraak
- Phone: 14 030
- Wait times: 1-4 weeks typical

### Language
- Dutch primary
- English available (limited)
- Bring translator if needed

## Postal Services

### PostNL
Main mail carrier:
- Delivery: Monday-Saturday
- Packages: Track via postnl.nl
- Post offices: In shops (Bruna, etc.)

### Package Delivery
- PostNL, DHL, DPD common
- Neighbor delivery if not home
- Pickup points everywhere
- Parcel lockers increasing

### Important Mail
Official letters (gemeente, Belastingdienst) come by post:
- Check mailbox regularly
- Keep address updated
- Important deadlines in letters

## Utilities

### Electricity & Gas
**Providers:**
- Vattenfall
- Eneco
- Essent
- Budget Energie
- Greenchoice

**Comparison sites:**
- independer.nl
- energievergelijk.nl
- pricewise.nl

**Contract types:**
- Variable (variabel) — price follows market
- Fixed (vast) — locked price for term

### Water
- Provider: Vitens (regional monopoly)
- No choice of provider
- Automatic enrollment at address
- Bill: €15-25/month

### Waste
- Collected by gemeente
- Residual waste: Container or bags
- Recycling: Separate bins
- Bulk waste: Schedule pickup
- Waste pass: For underground containers

## Phone & Internet

### Mobile Providers

| Provider | Network | Budget Option |
|----------|---------|---------------|
| KPN | Own | Simyo |
| Vodafone | Own | Hollandsnieuwe |
| T-Mobile | Own | Ben, Simpel |

### Home Internet

| Provider | Technology | Speed |
|----------|------------|-------|
| Ziggo | Cable | Up to 1Gbps |
| KPN | Fiber/DSL | Up to 1Gbps |
| T-Mobile | Fiber/DSL | Up to 1Gbps |

### TV
- Often bundled with internet
- Streaming replacing traditional
- NPO (public) requires no subscription

## Emergency Services

### Key Numbers

| Service | Number |
|---------|--------|
| Emergency | 112 |
| Police (non-emergency) | 0900-8844 |
| Amsterdam Airport info | 0900-0141 |
| Power outage | Liander: 0800-9009 |
| Gas leak | Liander: 0800-9009 |
| Water emergency | Vitens: 0800-0359 |

### Hospitals

| Hospital | Type | Address |
|----------|------|---------|
| UMC Utrecht | Academic | Heidelberglaan 100 |
| St. Antonius | General | Koekoekslaan 1 |
| Diakonessenhuis | General | Bosboomstraat 1 |

## Legal Services

### When Needed
- Employment disputes
- Housing issues
- Immigration questions
- Contracts review

### Free Legal Advice
- Juridisch Loket: juridischloket.nl
- Free initial consultation
- Phone and in-person

### Finding a Lawyer
- Orde van Advocaten: advocatenorde.nl
- Expat-focused firms exist
- Costs: €150-300/hour

## Consumer Protection

### Rights
- 14-day return (online purchases)
- 2-year warranty (minimum)
- Price displayed = price paid
- Clear contract terms required

### Complaints
1. Contact seller first
2. Use Klachtenkompas.nl
3. Consuwijzer.nl for advice
4. Legal action if needed

### Consumer Authority
- ACM (Authority Consumer & Market)
- Reports at acm.nl
- Protections are strong

## Government Offices

### Key Locations

| Office | Address | Purpose |
|--------|---------|---------|
| Stadskantoor | Stadsplateau 1 | Municipal services |
| Belastingdienst | Various | Tax office |
| UWV | Kanaalstraat 159 | Employment/benefits |
| IND | Via appointment | Immigration |

### Opening Hours
- Stadskantoor: Mon-Fri 8:30-17:00
- Some Saturday opening
- Always check before going
- Appointment usually required

## Useful Websites

| Service | Website |
|---------|---------|
| Municipality | utrecht.nl |
| Tax authority | belastingdienst.nl |
| Immigration | ind.nl |
| Benefits | toeslagen.nl |
| Legal help | juridischloket.nl |
| Consumer advice | consuwijzer.nl |
| Energy comparison | independer.nl |
| Healthcare comparison | zorgwijzer.nl |

## Tips

1. **Get DigiD immediately** — unlocks everything online
2. **Keep documents organized** — Dutch bureaucracy needs paperwork
3. **Check mail regularly** — important deadlines come by post
4. **Save everything** — receipts, contracts, correspondence
5. **Compare utilities annually** — prices vary significantly
6. **Apply for subsidies** — many expats miss eligible benefits
7. **Use English option** — most government sites have it
8. **Appointment for everything** — spontaneous visits rarely work
