# Utrecht — Healthcare System

## System Overview

Dutch healthcare is high-quality but works differently than many countries. Understanding the system prevents frustration.

| Aspect | Reality |
|--------|---------|
| Quality | Excellent |
| Cost | Mandatory insurance (~€130/month) |
| Access | Via GP gatekeeper |
| Wait times | Can be long for non-urgent |
| Language | Dutch primary, English usually available |

## How It Works

### The GP Gatekeeper (Huisarts)
Your GP is the center of everything:
- First point of contact for all health issues
- Refers to specialists (you can't go directly)
- Manages chronic conditions
- Prescribes medications
- Coordinates care

### Referral System
Want to see a specialist?
1. See GP first
2. GP assesses need
3. GP refers (or not)
4. Then you can book specialist

**Exception:** Emergency room for emergencies only.

### Why This System
- Prevents unnecessary specialist visits
- GP knows you holistically
- More efficient overall
- Can feel limiting at first

## Mandatory Insurance

### Basisverzekering (Basic Insurance)
Required by law for all residents.

**Cost:** €130-160/month (2026)

**What's Covered:**
- GP consultations
- Hospital care
- Most medications
- Mental health (limited)
- Maternity care
- Ambulance

**What's NOT Covered (basic):**
- Dental (adults)
- Physiotherapy (first sessions)
- Glasses/contacts
- Alternative medicine
- Some medications

### Eigen Risico (Deductible)
**2026:** €385/year

- First €385 of most care = you pay
- GP visits: Exempt from deductible
- Resets January 1
- Can choose higher deductible = lower premium

### Aanvullende Verzekering (Additional Insurance)
Optional extras:

| Coverage | Monthly Cost |
|----------|--------------|
| Dental basic | €5-15 |
| Dental comprehensive | €15-30 |
| Physiotherapy | €5-15 |
| Alternative medicine | €5-10 |
| Glasses/contacts | €5-10 |

### Timeline
- Must get insurance within 4 months of registration
- Coverage starts from registration date
- Penalty for late enrollment: €455 + forced plan

### Providers

| Provider | Notes |
|----------|-------|
| Zilveren Kruis | Largest |
| CZ | Good service |
| VGZ | Strong in Utrecht |
| OHRA | Budget-friendly |
| Menzis | Solid option |

### Comparing
- independer.nl
- zorgwijzer.nl
- Change yearly (November) if desired

## Finding a GP (Huisarts)

### Why It's Hard
Many practices are full. Start searching immediately.

### How to Find
1. Search: zorgkaartnederland.nl
2. Filter by location
3. Call practices
4. Ask: "Neemt u nieuwe patiënten aan?"
5. Repeat until successful

### Registration
- Bring: ID, insurance card, BSN
- Fill intake forms
- May have brief meeting
- Get practice card (pasje)

### Expat-Friendly Practices
Some practices specialize in internationals:
- English-speaking staff
- Cultural awareness
- Often easier registration
- May be further from home

## Using Healthcare

### GP Appointments

**Booking:**
- Call practice (usually morning)
- Online booking (if available)
- Same-day urgent possible
- Routine: Days/weeks wait

**Appointment Length:**
- 10-15 minutes standard
- Be concise and direct
- Come prepared with symptoms
- Ask for what you need

**Cost:**
- Free with insurance
- No deductible applies

### After-Hours GP (Huisartsenpost)

For urgent (not emergency) issues outside hours:

**Utrecht:**
- Phone: 0900-3336333
- Location: At UMC Utrecht
- Hours: Evenings, nights, weekends
- Triage by phone first

**When to Call:**
- Can't wait until regular GP hours
- Not life-threatening
- Sudden illness/injury

### Emergency Room (Spoedeisende Hulp)

**Only for real emergencies:**
- Life-threatening
- Severe injuries
- Chest pain
- Difficulty breathing
- Heavy bleeding

**Where in Utrecht:**
- UMC Utrecht: Heidelberglaan 100
- St. Antonius: Koekoekslaan 1

**Costs:**
- Covered by insurance (after deductible)
- Misuse can mean high costs

### Specialists

**Getting Referral:**
1. GP appointment
2. Explain need
3. GP assesses
4. If approved, referral letter issued
5. Book with specialist yourself

**Common Wait Times:**
- Dermatologist: 2-6 weeks
- Psychiatrist: Months
- Orthopedist: 2-8 weeks
- Routine: Varies widely

**Costs:**
- Covered after deductible
- Some extra costs possible

## Mental Health

### Coverage
Basic insurance covers:
- GP consultation (no deductible)
- Referral to psychologist/psychiatrist
- Limited sessions per year

### Access Issues
- Long waiting lists (months common)
- Shortage of providers
- Private options faster but expensive

### Options

| Option | Wait | Cost |
|--------|------|------|
| GP mental health support | Days | Free |
| POH-GGZ (practice counselor) | 1-2 weeks | Free |
| Psychologist (basic) | Weeks-months | After deductible |
| Private psychologist | Shorter | €80-150/session |
| Psychiatrist | Months | After deductible |

### Crisis
- 113 Zelfmoordpreventie: 0800-0113
- Crisisdienst via huisartsenpost

## Dental Care

### Not in Basic Insurance
Adults pay out of pocket or need additional insurance.

### Costs

| Treatment | Price |
|-----------|-------|
| Checkup | €30-50 |
| Cleaning | €50-100 |
| Filling | €80-150 |
| Root canal | €200-500 |
| Crown | €400-800 |
| Extraction | €50-150 |

### Strategy
- Get dental insurance if using regularly
- Compare: Often cheaper to pay per visit if healthy teeth
- Annual checkup: Recommended

### Finding a Dentist
- zorgkaartnederland.nl
- Often easier than GP
- Some have wait lists
- Expat-friendly options exist

## Pharmacy (Apotheek)

### How It Works
1. GP prescribes
2. Prescription sent electronically
3. Pick up at any pharmacy
4. Usually same day

### Costs
- Most covered by insurance
- Some have small copay
- Deductible may apply

### Over-the-Counter
Pharmacies sell more than supermarkets:
- Ibuprofen (higher doses)
- Allergy medication
- Basic treatments
- Pharmacist can advise

### After-Hours Pharmacy
Dienstapotheek (duty pharmacy) rotates:
- Check apotheek.nl
- For urgent prescriptions
- Higher fees may apply

## Hospitals in Utrecht

### UMC Utrecht (University Medical Center)
- Address: Heidelberglaan 100
- Type: Academic hospital
- Specialties: Top-tier, complex cases
- Research hospital

### St. Antonius
- Address: Koekoekslaan 1
- Type: General hospital
- Good all-round care

### Diakonessenhuis
- Address: Bosboomstraat 1
- Type: General hospital
- City center location

### Choosing
- GP refers to appropriate hospital
- Can express preference
- Specialist availability matters

## Maternity Care

### System
- Midwife-led for low-risk
- Hospital for high-risk
- Home birth common (Dutch tradition)
- Hospital stays: Short (often same day)

### Coverage
- Fully covered by basic insurance
- No deductible for maternity
- Postpartum care (kraamzorg) included

### Process
1. Confirm pregnancy with GP
2. GP refers to midwife (verloskundige)
3. Regular checkups with midwife
4. Delivery at home, birth center, or hospital
5. Kraamzorg visits for first week

## Vaccinations

### Adults
- Flu vaccine: Annual for high-risk (free) or anyone (€20-30)
- COVID boosters: As recommended
- Travel vaccines: At GGD (travel clinic)

### Children
- RIVM national program
- Free, scheduled
- Given at consultatiebureaus (child health centers)
- Very high participation rate

## Common Frustrations

### "Take a paracetamol"
Dutch GPs prescribe less:
- Start with basic treatment
- See if it resolves
- Return if not
- Not dismissive, just pragmatic

### Can't See Specialist Directly
- System design, not obstruction
- GP genuinely assesses
- Push back if you feel unheard
- Second opinions possible

### Long Waits
- Mental health especially
- Some specialists
- Private option if urgent

### Language Barriers
- Most medical staff speak English
- Records often in Dutch
- Bring translator for complex issues
- Patient portal often Dutch-only

## Healthcare Subsidies

### Zorgtoeslag (Healthcare Allowance)
Government help with insurance costs.

**Eligibility:**
- Income below threshold
- Assets below threshold
- Resident in Netherlands

**Amount:**
- Up to €111/month (single, 2026)
- Apply via toeslagen.nl with DigiD

## Tips

1. **Register with GP immediately** — Before you're sick
2. **Get insurance within 4 months** — Or face penalties
3. **Understand the deductible** — First €385 is yours
4. **GP is first stop** — Always
5. **Be direct about symptoms** — Dutch appreciate clarity
6. **Mental health waits** — Start process early if needed
7. **Dental insurance** — Calculate if worth it for you
8. **Keep your insurance card** — Carry or photo
9. **Zorgtoeslag** — Apply if eligible
10. **After-hours GP** — Not ER, use huisartsenpost

## Useful Contacts

| Service | Contact |
|---------|---------|
| Emergency | 112 |
| Huisartsenpost Utrecht | 0900-3336333 |
| Poison Control | 030-274 8888 |
| Mental health crisis | 0900-0113 |
| GGD (public health) | 030-286 3500 |
