# Utrecht — Practical Food Guide

## Dining Hours

### Dutch Meal Times
| Meal | Time | Reality |
|------|------|---------|
| Breakfast | 7:00-9:00 | Often at home |
| Coffee break | 10:00-10:30 | Sacred |
| Lunch | 12:00-13:00 | Usually quick |
| Afternoon coffee | 15:00-16:00 | Common |
| Dinner | 18:00-19:30 | Early! |
| Late dinner | 20:00+ | Limited options |

### Kitchen Closing
- Most kitchens close: 21:00-22:00
- Last orders: 30-60 min before closing
- Fine dining: Often earlier last seating
- Weekend: Slightly later

### Sunday Hours
- Many restaurants open late (12:00+)
- Some closed entirely
- Check before going
- Brunch popular

## Coffee Culture

### The Ritual
Coffee is essential to Dutch life:
- Mid-morning coffee break
- After-lunch coffee
- Meeting starts with coffee
- "Kopje koffie?" = social invitation

### Where to Get Coffee

**Chain Options:**
| Chain | Price | Quality |
|-------|-------|---------|
| Starbucks | €4-6 | Consistent |
| Bagels & Beans | €3-5 | Good |
| Anne&Max | €3-5 | Good |
| Simon Lévelt | €3-4 | Quality beans |

**Local Roasters/Cafés:**
| Café | Notes |
|------|-------|
| Blackbird Coffee | Third-wave |
| Village Coffee | Specialty |
| Koffie Leute | Local favorite |
| Broei | Also brunch |

### Coffee Types
| Dutch | English |
|-------|---------|
| Koffie | Regular coffee |
| Koffie verkeerd | Coffee with milk |
| Cappuccino | Cappuccino |
| Espresso | Espresso |
| Filterkoffie | Filter coffee |

### Price Guide
- Basic coffee: €2.50-3.50
- Specialty coffee: €3.50-5.00
- Usually includes small cookie

## Bars & Drinking

### Types of Bars

**Brown Café (Bruine Kroeg):**
- Traditional Dutch pub
- Dark wood, cozy
- Beer focus
- Often serve bitterballen
- Examples: Café Olivier, Café Ledig Erf

**Grand Café:**
- Larger, more open
- Full food menu
- More upscale
- Good for groups

**Beer Bars:**
- Craft beer focus
- Belgian imports
- Local breweries
- Examples: Olivier, de Drie Dorstige Herten

**Cocktail Bars:**
- Growing scene
- Higher prices
- More modern
- Reservations sometimes

**Wine Bars:**
- Several in center
- By glass or bottle
- Cheese/charcuterie

### Drink Prices

| Drink | Price |
|-------|-------|
| Beer (pils) | €3-5 |
| Craft beer | €5-7 |
| Wine (glass) | €5-8 |
| Cocktail | €10-14 |
| Soft drink | €2-4 |

### Drinking Culture
- Borrel (after-work drinks): Very Dutch
- Proost! = Cheers
- Pace yourself (Dutch don't appreciate excess)
- Bitterballen mandatory with beer
- Jenever (Dutch gin) for adventurous

### Happy Hour
- Some places offer
- Usually 16:00-18:00
- Not as common as other countries

## Dietary Needs

### Vegetarian

**Awareness:**
- Good and improving
- Most restaurants have options
- Ask if not on menu

**Dedicated Options:**
| Restaurant | Type |
|------------|------|
| Gys | Vegan café |
| Vegetarisch Restaurant | Traditional |
| Various with options | Most places |

**Easy Cuisines:**
- Indian (many veg dishes)
- Indonesian (specify no meat)
- Italian (pasta, pizza)
- Middle Eastern (falafel, mezze)

### Vegan

**Awareness:**
- Growing but specify clearly
- Some Dutch dishes have hidden dairy
- Check ingredients

**Options:**
- Dedicated vegan spots emerging
- "Veganistisch" on menus
- Health food stores for groceries

**Challenges:**
- Cheese everywhere
- Butter in traditional cooking
- Limited options at traditional restaurants

### Gluten-Free

**Awareness:**
- Moderate
- "Glutenvrij" = gluten-free
- Ask specifically

**Options:**
- Some dedicated menus
- Asian restaurants easier
- Gluten-free pasta available at some Italian

**Groceries:**
- Albert Heijn has gluten-free section
- Specialty health stores
- Online ordering

### Halal

**Availability:**
- Turkish restaurants
- Middle Eastern spots
- Some Indonesian
- Growing options

**Where:**
- Lombok neighborhood strong
- Ask specifically elsewhere
- Some chains (like KFC) have halal options

### Kosher

**Availability:**
- Very limited in Utrecht
- Amsterdam better for strict kosher
- Some vegetarian options work

### Allergies

**Communication:**
- Netherlands takes allergies seriously
- Restaurants legally required to inform
- Ask clearly, staff usually knowledgeable
- "Ik heb een allergie voor..." = I'm allergic to...

**Common Allergens:**
| Dutch | English |
|-------|---------|
| Noten | Nuts |
| Pinda's | Peanuts |
| Gluten | Gluten |
| Lactose | Lactose |
| Schaaldieren | Shellfish |
| Eieren | Eggs |

## Tipping

### The Rules
- **Not mandatory** (staff paid living wage)
- **Appreciated** for good service
- **Typical**: 5-10% or rounding up
- **Fine dining**: 10% appropriate
- **Bad service**: Tipping not expected

### How To
- Cash: Leave on table
- Card: Add to total or give separately
- "Klopt zo" = keep the change
- Don't over-tip (creates awkwardness)

## Reservations

### When Needed
| Situation | Reserve? |
|-----------|----------|
| Weekend dinner | Yes |
| Popular restaurants | Yes |
| Groups (5+) | Yes |
| Fine dining | Always |
| Weekday lunch | Usually not |
| Casual spots | Usually not |

### How to Book
- Phone (traditional, reliable)
- Online via restaurant website
- TheFork app
- Google reservation button
- Instagram DM (some places)

### Timing
- Book 2-7 days ahead for popular
- Same day sometimes works
- Special occasions: Weeks ahead

## Payment

### Card vs Cash
- Cards accepted almost everywhere
- Maestro/debit: Universal
- Visa/Mastercard: Most places
- Cash: Always works
- Some small spots cash-only (rare)

### Splitting Bills
- Very common (Dutch)
- "Gescheiden" = separate bills
- Tikkie app for settling
- Not awkward to request

### Paying
- Ask for "de rekening" (the bill)
- Often bring card reader to table
- Tip in cash or add to card

## Grocery Shopping

### Supermarket Tiers

| Chain | Type | Price |
|-------|------|-------|
| Lidl | Budget | € |
| Aldi | Budget | € |
| Jumbo | Standard | €€ |
| Albert Heijn | Standard | €€ |
| Marqt | Premium | €€€ |
| Ekoplaza | Organic | €€€ |

### Opening Hours
- Weekdays: 8:00-22:00 (varies)
- Saturday: 8:00-21:00
- Sunday: 12:00-18:00 (often)
- AH To Go (station): Extended hours

### Speciality Stores
| Type | Where |
|------|-------|
| Asian groceries | Amazing Oriental |
| Turkish | Various, Lombok |
| Indonesian | Toko shops |
| Organic | Ekoplaza, farmers markets |
| International | World of Food |

### Market Days
| Market | Day | Best For |
|--------|-----|----------|
| Vredenburg | Saturday | Everything |
| Various neighborhood | Various | Local goods |

## Takeaway & Delivery

### Apps
| App | Notes |
|-----|-------|
| Thuisbezorgd | Most common |
| Uber Eats | Growing |
| Deliveroo | Some areas |

### Costs
- Delivery fee: €1-4
- Service fee: Often added
- Minimum order: €10-20 common
- Tips optional (can add in app)

### Pickup
- Often cheaper than delivery
- Better food quality (not sitting)
- Many restaurants offer

## Late Night Food

### Options (After 22:00)
| Type | Availability |
|------|--------------|
| Döner/kebab | Until 2-3 AM |
| FEBO (automat) | Late |
| Pizza | Some late |
| McDonald's | Late some locations |
| Snackbars | Variable |

### Reality
- Utrecht quieter than Amsterdam
- Options limited after midnight
- Eat earlier if quality matters

## Food Etiquette

### At Restaurants
- Wait to be seated (usually)
- Water not automatic (ask and pay)
- Bread not automatic (may cost)
- Pace is leisurely
- Don't rush the staff

### General
- "Eet smakelijk" = Enjoy your meal
- Wait for everyone before eating
- Fork in left hand, knife in right
- Finish your plate (waste frowned upon)

## Budget Eating

### Strategies
1. **Lunch specials** — Many offer good value
2. **Takeaway** — Often cheaper
3. **Supermarket prepared** — AH salads, etc.
4. **Markets** — Fresh and affordable
5. **Lombok** — Best value neighborhood
6. **Cook at home** — Obviously
7. **Student haunts** — Follow students
8. **Happy hour** — Where available

### Budget Meal Costs
| Type | Price |
|------|-------|
| Supermarket lunch | €5-8 |
| Kebab/snack | €5-10 |
| Asian takeaway | €8-12 |
| Casual lunch out | €12-18 |
| Budget dinner out | €15-25 |

## Apps & Resources

| Resource | Purpose |
|----------|---------|
| Google Maps | Reviews, info |
| TheFork | Reservations |
| Thuisbezorgd | Delivery |
| Instagram | Food accounts |
| TripAdvisor | Tourist perspective |

## Quick Reference

### Common Dutch Food Words
| Dutch | English |
|-------|---------|
| Eten | Food |
| Drinken | Drink |
| Ontbijt | Breakfast |
| Lunch | Lunch |
| Diner | Dinner |
| Rekening | Bill |
| Fooi | Tip |
| Vegetarisch | Vegetarian |
| Veganistisch | Vegan |
| Allergieën | Allergies |
