# Utrecht — Cycling

## Cycling Culture

In Utrecht, cycling isn't just transport—it's identity. The city is designed for bikes first, everything else second.

| Statistic | Value |
|-----------|-------|
| Daily cycling trips | 125,000+ |
| Mode share | 60%+ |
| Bike parking at station | 12,500 spaces (largest in world) |
| Bike lanes | 200+ km |
| Bikes per capita | 1.1 |

## Getting a Bike

### Buying Options

| Option | Price | Pros | Cons |
|--------|-------|------|------|
| Marktplaats (used) | €50-150 | Cheap, fast | No warranty |
| Bike shop (used) | €100-250 | Some warranty | Pricier |
| New basic (omafiets) | €300-500 | Reliable | Target for theft |
| New city bike | €500-1,000 | Quality | Investment |
| E-bike | €1,500-3,000 | Easy | Expensive, theft risk |

### Swapfiets (Subscription)
Monthly rental service:
- €19/month (regular)
- €59/month (e-bike)
- Includes maintenance and repairs
- Swap anytime
- Good for newcomers

### OV-Fiets (Train Station Rental)
For station-to-station trips:
- €4.55/day
- Need personal OV-chipkaart
- Available at all stations
- Return within 24 hours

### What to Look For
- Lights (front and back)
- Working brakes (front and back)
- Bell
- Lock (or buy separately)
- Matching frame size
- Chain guard (keeps clothes clean)
- Rear rack (praktisch)

## Types of Bikes

### Omafiets (Grandma Bike)
- Classic Dutch style
- Upright position
- Step-through frame
- Heavy but durable
- Most common

### Stadsfiets (City Bike)
- Modern version of omafiets
- Lighter
- More gears
- Similar practicality

### Bakfiets (Cargo Bike)
- Box in front for kids/cargo
- Very Dutch family transport
- Slow but practical
- Expensive (€2,000+)

### E-Bike
- Electric assist
- Good for commuters
- Heavy
- High theft target
- Battery management required

### Racing/Sport Bikes
- Faster but impractical
- Less comfortable for daily use
- Requires sportswear

## Cycling Rules

### Legal Requirements
| Requirement | Fine if Missing |
|-------------|-----------------|
| Front light (white) | €55 |
| Rear light (red) | €55 |
| Working brakes | €55 |
| Bell | €40 |
| Reflectors | €40 |

### Traffic Rules
- **Right has priority** at unmarked crossings
- **Sharks teeth** (white triangles) = you yield
- **Red light** = stop (fine: €110)
- **Phone use** = €140 fine
- **Wrong way** on bike lane = €95

### Unwritten Rules
- **Signal with hand** when turning
- **Look before entering roundabout**
- **Don't stop in bike lane**
- **Ring bell** when passing
- **Keep right** when slow
- **Never brake suddenly** without warning

### Alcohol
- Legal limit exists (lower than car)
- Fine: €100+
- Rarely enforced but possible
- Use common sense

## Infrastructure

### Bike Lanes (Fietspaden)
- Everywhere
- Separated from cars
- Red asphalt typically
- Two-way often marked

### Types of Paths

| Type | Dutch | Description |
|------|-------|-------------|
| Mandatory bike lane | Fietspad | Must use |
| Suggested bike lane | Fietsstrook | On road, marked |
| Bike street | Fietsstraat | Bikes priority, cars allowed |
| Mixed traffic | Gemengd | Shared with cars |

### Roundabouts
- Bikes have priority (usually)
- Cars must yield
- Check signage at each
- Be visible and predictable

### Intersections
- Bike-specific traffic lights
- Sometimes separate phases
- Watch for turning cars
- Make eye contact with drivers

## Bike Parking

### Stationsplein (Central Station)
- World's largest bike parking
- 12,500 spaces
- Free for first 24 hours
- Underground, secure
- Never full

### Street Parking
- Designated racks everywhere
- Some areas prohibited
- Look for signs
- Lock through frame AND fixed object

### At Home
- Indoor storage ideal
- Balcony common
- Street = theft risk
- Insure valuable bikes

### Fines for Bad Parking
- Wrong area: Bike removed
- €25 to retrieve
- Very enforced

## Locks

### Two-Lock Rule
Always use two locks:
1. **Ring lock** (built into frame)
2. **Chain lock** (to fixed object)

### Lock Types

| Type | Security | Price |
|------|----------|-------|
| Ring lock (frame) | Medium | Built-in |
| Chain lock (thick) | High | €40-80 |
| U-lock | High | €30-60 |
| Cable lock | Low | €15-30 (not recommended alone) |

### Locking Strategy
- Lock through frame, not just wheel
- Lock to something fixed (can't be lifted)
- Don't leave in same spot too long
- Inside overnight if possible

## Bike Theft

### Reality
- Happens constantly
- Police don't investigate small theft
- Report for insurance purposes
- Cheap bikes = less target

### Prevention
- Two good locks
- Indoor parking when possible
- Register at fietsregistratie.nl
- Don't leave valuable bikes outside overnight
- Cheap ugly bike = best protection

### If Stolen
1. Report at police.nl (for insurance)
2. Check Marktplaats (bikes resold there)
3. Claim insurance if covered
4. Accept and move on

### Insurance
- Some home insurance covers
- Specific bike insurance: €3-10/month
- Worth it for expensive bikes
- Check deductible

## Maintenance

### DIY Basics
| Task | Frequency |
|------|-----------|
| Pump tires | Weekly |
| Oil chain | Monthly |
| Check brakes | Monthly |
| Check lights | Before dark season |

### Bike Shops
- Many in Utrecht
- Repairs while you wait (often)
- Basic tune-up: €30-50
- Flat tire: €10-15
- Professional service recommended annually

### Common Issues
- Flat tire (band lek): Most common
- Chain issues: Oil helps
- Brake pads: Wear out
- Lights: Check batteries

## Cycling in Weather

### Rain
- Dutch don't stop for rain
- Rain pants (regenbroek)
- Rain jacket with hood
- Waterproof bags
- Accept getting wet

### Wind
- Can be brutal
- Lower gears
- Allow more time
- Headwind = workout

### Ice/Snow
- Rare but dangerous
- Slower and careful
- Some stay home
- Salt trucks help
- Bike lanes cleared quickly

### Dark Months
- Lights essential
- Reflective clothing helps
- Be extra visible
- Drivers can't see you

## Cycling with Children

### Options by Age

| Age | Transport |
|-----|-----------|
| Baby-1 year | Maxi-Cosi on special carrier |
| 1-4 years | Front seat (voorzitje) or back seat |
| 2-5 years | Bakfiets |
| 4-8 years | Back seat or own bike |
| 5+ years | Own bike + supervision |

### Car Seats for Bikes
- Front: For interaction, balance
- Back: For heavier children
- Both require proper mounting

### Bakfiets (Cargo Bike)
- Fits 2-3 children in front box
- Weather protection available
- Slow but practical
- Very Dutch solution

### Children's Bikes
- Start training around 3-4
- Balance bikes first
- Practice in parks
- Traffic rules from the start

## Cycling to Work

### Common
- 60% of trips by bike
- Shower facilities at some offices
- Business attire on bikes normal
- Cycling is professional

### Employer Benefits
- Some provide bike allowance
- Tax-advantaged bike purchase
- E-bike schemes
- Shower facilities

### Commute Tips
- Waterproof bag for laptop
- Change of clothes (if needed)
- Allow buffer time
- Know multiple routes

## Long-Distance Cycling

### Day Trips
- Utrechtse Heuvelrug (forests/hills)
- Along the rivers
- To nearby cities
- Country roads (polders)

### Routes
- LF routes (national long-distance)
- Regional marked routes
- ANWB fietsknooppunten (numbered junction system)

### Planning
- routeplanner.fietsersbond.nl
- ANWB Fiets app
- Google Maps (cycling option)

## Apps & Resources

| App | Purpose |
|-----|---------|
| Google Maps | Navigation (cycling mode) |
| ANWB Fiets | Routes, junction planning |
| Fietsersbond | Route planner |
| Swapfiets | Subscription service |
| OV-fiets | Station bike rental |

## Quick Tips

1. **Two locks always** — Not optional
2. **Lights at night** — Law and safety
3. **Ring bell** — Be heard
4. **Signal turns** — Hand out
5. **Keep right** — Let faster pass
6. **Eye contact** — With cars at crossings
7. **Maintain bike** — Prevents breakdowns
8. **Accept weather** — Rain is normal
9. **Ugly bike** — Best theft protection
10. **Enjoy it** — Best way to experience Utrecht
