# Utrecht — Cost of Living

## Overview

Utrecht is expensive by global standards but reasonable for Western Europe. The Netherlands combines high taxes with high services — you pay more but get reliable infrastructure, healthcare, and social safety net.

**Comparison**: Slightly cheaper than Amsterdam, similar to Rotterdam/The Hague, expensive for Southern/Eastern Europeans.

## Monthly Budget Examples

### Single Person — Tight Budget
| Category | Amount |
|----------|--------|
| Rent (room/studio) | €800-1,000 |
| Utilities | €100-150 |
| Health insurance | €130 |
| Food (groceries) | €200-250 |
| Transport (bike) | €20-30 |
| Phone/internet | €30 |
| Misc/social | €150 |
| **Total** | **€1,430-1,740** |

### Single Person — Comfortable
| Category | Amount |
|----------|--------|
| Rent (1BR) | €1,300-1,600 |
| Utilities | €150-200 |
| Health insurance | €130 |
| Food (mixed) | €350-400 |
| Transport | €50-100 |
| Phone/internet | €40 |
| Entertainment | €200 |
| Savings | €200+ |
| **Total** | **€2,420-2,870** |

### Couple — Comfortable
| Category | Amount |
|----------|--------|
| Rent (2BR) | €1,600-2,000 |
| Utilities | €200-250 |
| Health insurance | €260 |
| Food | €450-550 |
| Transport | €80-150 |
| Phone/internet | €60 |
| Entertainment | €300 |
| Savings | €400+ |
| **Total** | **€3,350-3,970** |

### Family (2 adults, 2 children)
| Category | Amount |
|----------|--------|
| Rent (3BR/house) | €2,000-2,800 |
| Utilities | €300-400 |
| Health insurance | €260 + kids free |
| Food | €700-900 |
| Childcare | €500-1,500 (after subsidy) |
| Transport | €150-250 |
| School costs | €50-100 (Dutch) or €1,000-2,000 (international) |
| Misc/activities | €400 |
| **Total** | **€4,360-6,700** |

## Housing

### Rental Prices (Feb 2026)

| Type | Center | Good Area | Budget Area |
|------|--------|-----------|-------------|
| Room (shared) | €500-700 | €400-550 | €350-450 |
| Studio | €1,200-1,600 | €1,000-1,300 | €800-1,000 |
| 1BR | €1,500-2,200 | €1,200-1,700 | €900-1,300 |
| 2BR | €1,800-2,800 | €1,500-2,200 | €1,200-1,600 |
| 3BR | €2,500-4,000 | €2,000-3,000 | €1,500-2,000 |
| House (garden) | €2,500-4,500 | €2,000-3,500 | €1,800-2,500 |

### Additional Housing Costs

| Cost | Amount |
|------|--------|
| Deposit | 1-3 months rent |
| Agency fee (if used) | 1 month rent |
| Service costs | €50-200/month |
| Municipal taxes | €300-600/year |
| Water | €15-25/month |
| Gas/electric | €100-250/month |
| Internet | €35-50/month |
| Contents insurance | €5-15/month |

### Housing Market Reality
- Extremely competitive
- 10-30 applicants per listing common
- Expats often pay more to secure housing
- Social housing: 10+ year waitlist

## Utilities

### Monthly Averages

| Utility | 1BR | 2BR | House |
|---------|-----|-----|-------|
| Electricity + Gas | €100-150 | €150-250 | €200-350 |
| Water | €15-25 | €25-35 | €35-50 |
| Internet | €35-50 | €35-50 | €35-50 |
| Total | €150-225 | €210-335 | €270-450 |

**Note**: Dutch energy prices volatile since 2022. Old buildings with poor insulation = much higher bills.

### Energy Labels
Check apartment energy label (A-G):
- A/B: Modern, efficient, lower bills
- C/D: Average
- E/F/G: Old, poorly insulated, high bills

## Healthcare

### Mandatory Insurance

**Basisverzekering (Basic insurance)**: €130-160/month
- Required by law for all residents
- Covers GP, hospital, most medications
- Must purchase within 4 months of registration

**Eigen risico (Deductible)**: €385/year (2026)
- First €385 of most care = your cost
- GP visits exempt
- Can opt for higher deductible = lower premium

### Additional Insurance
- **Aanvullende verzekering**: Optional extras
- Dental, physio, alternative medicine
- €10-50/month depending on coverage

### Real Healthcare Costs

| Item | Cost |
|------|------|
| GP visit | Free (with insurance) |
| Specialist | Free after referral + deductible |
| Hospital stay | Covered after deductible |
| Dental cleaning | €50-100 (not in basic) |
| Dental filling | €80-150 (not in basic) |
| Prescription meds | Usually covered, some copays |

## Food

### Grocery Costs (Monthly)

| Level | Single | Couple |
|-------|--------|--------|
| Budget | €150-200 | €250-350 |
| Average | €200-300 | €350-500 |
| Quality | €300-400 | €500-700 |

### Supermarket Tiers
- **Budget**: Aldi, Lidl (cheapest)
- **Standard**: Albert Heijn, Jumbo
- **Premium**: Marqt, Ekoplaza (organic)

### Eating Out

| Type | Per Person |
|------|------------|
| Fast food | €8-12 |
| Casual dinner | €20-35 |
| Nice restaurant | €40-60 |
| Fine dining | €70-120 |
| Coffee | €2.50-4 |
| Beer (bar) | €4-6 |
| Wine (glass) | €5-8 |

## Transport

### Cycling (Primary Mode)
| Item | Cost |
|------|------|
| Used bike | €50-200 |
| New bike (basic) | €300-500 |
| New bike (good) | €500-1,000 |
| E-bike | €1,500-3,000 |
| OV-fiets (rental) | €4.55/day |
| Repairs/maintenance | €50-100/year |
| Locks | €30-80 |

### Public Transport
| Item | Cost |
|------|------|
| OV-chipkaart (card) | €7.50 |
| Single tram/bus | €2-4 |
| Day pass (Utrecht) | €8 |
| NS subscription | €350-400/month (unlimited) |
| Utrecht-Amsterdam single | €9 |

### Car (If You Must)
| Item | Cost |
|------|------|
| Used car | €5,000-15,000 |
| Insurance | €50-150/month |
| Road tax | €30-100/month |
| Fuel | €2.10/liter |
| Parking (center) | €4-5/hour |
| Parking permit | €150-400/year |

**Note**: Cars expensive and unnecessary in Utrecht. Most residents cycle.

## Childcare & Education

### Childcare

| Type | Monthly Cost | After Subsidy |
|------|--------------|---------------|
| Daycare (full-time) | €1,500-2,000 | €300-1,200 |
| Daycare (part-time) | €700-1,000 | €150-600 |
| BSO (after-school) | €300-500 | €100-300 |
| Nanny | €2,000-3,500 | Varies |

**Kinderopvangtoeslag**: Government subsidy based on income. Apply via Belastingdienst.

### Schools

| Type | Annual Cost |
|------|-------------|
| Dutch public | Free (some materials €50-100) |
| Dutch private | €200-2,000 |
| International (primary) | €10,000-18,000 |
| International (secondary) | €15,000-25,000 |

## Taxes

### Income Tax (2026)

| Income | Rate |
|--------|------|
| Up to €75,518 | 36.97% |
| Above €75,518 | 49.5% |

### 30% Ruling (Expat Benefit)
Highly skilled migrants can receive 30% of salary tax-free:
- Recruitment from abroad
- Specific salary thresholds
- Master's degree requirement
- Maximum 5 years
- Saves thousands per year

### Other Taxes
- **BTW (VAT)**: 21% (9% reduced for food, hotels)
- **Municipal tax**: €300-600/year
- **Water authority tax**: €300-400/year

## Comparison with Other Cities

### Monthly Budget (Single, Comfortable)

| City | Estimate |
|------|----------|
| Utrecht | €2,500-2,800 |
| Amsterdam | €2,800-3,300 |
| Rotterdam | €2,300-2,700 |
| The Hague | €2,400-2,800 |
| Eindhoven | €2,100-2,500 |

Utrecht is slightly cheaper than Amsterdam (mainly housing) but otherwise similar to other major Dutch cities.

## Money-Saving Tips

1. **Cycle everywhere** (car = money drain)
2. **Cook at home** (eating out adds up)
3. **Aldi/Lidl for groceries** (40-50% cheaper than AH)
4. **Museumkaart** if staying (€65 = unlimited museums)
5. **OV-fiets** for station-to-station trips
6. **Dal Vrij** train subscription if commuting off-peak
7. **Marktplaats** for secondhand everything
8. **Energy contracts** — compare at independer.nl
9. **Childcare subsidies** — apply immediately
10. **30% ruling** — fight for it if eligible
