# Utrecht — Climate & Weather

## Overview

Temperate maritime climate. Mild but wet. No extremes but constant variation. Prepare for rain any day, any season.

| Season | Temp Range | Rainfall | Character |
|--------|------------|----------|-----------|
| Spring (Mar-May) | 6-17°C | Moderate | Unpredictable |
| Summer (Jun-Aug) | 15-25°C | Moderate | Pleasant, some heat waves |
| Autumn (Sep-Nov) | 6-16°C | High | Rainy, windy |
| Winter (Dec-Feb) | 0-7°C | Moderate | Grey, occasional freeze |

## Monthly Breakdown

| Month | Avg High | Avg Low | Rain Days | Daylight |
|-------|----------|---------|-----------|----------|
| January | 5°C | 0°C | 13 | 8h |
| February | 6°C | 0°C | 10 | 10h |
| March | 10°C | 2°C | 11 | 12h |
| April | 14°C | 4°C | 10 | 14h |
| May | 18°C | 8°C | 10 | 16h |
| June | 20°C | 11°C | 10 | 17h |
| July | 23°C | 13°C | 11 | 16h |
| August | 22°C | 13°C | 10 | 14h |
| September | 19°C | 10°C | 11 | 12h |
| October | 14°C | 7°C | 12 | 10h |
| November | 9°C | 3°C | 14 | 9h |
| December | 6°C | 1°C | 13 | 8h |

## Season Details

### Spring (March-May)

**Character:** Unpredictable. Can feel like winter or summer within same week.

**What to Expect:**
- Tulip season (April-May)
- Longer days, improving mood
- Temperature swings (8°C to 20°C)
- Rain showers
- Windy

**Clothing:**
- Layers essential
- Light jacket (waterproof)
- Umbrella
- Mix of warm and cool options

**Events:**
- King's Day (April 27) — hope for sun
- Easter markets
- Terrace season begins

### Summer (June-August)

**Character:** Pleasant, occasionally hot. Best time for outdoor life.

**What to Expect:**
- 20-25°C typical
- Heat waves: 30-35°C (increasing frequency)
- Long days (sunset 22:00 in June)
- Outdoor everything
- Still rains

**Clothing:**
- Light clothing
- Still bring rain jacket
- Sunglasses
- Sunscreen (UV stronger than expected)

**Events:**
- Festival season
- Terrace culture peak
- Canal swimming
- Day trips to beach

**Heat Wave Tips:**
- No AC in most buildings
- Buy a fan before they sell out
- Stay hydrated
- Parks and water for relief

### Autumn (September-November)

**Character:** Rainy, windy, progressively darker. Can be beautiful or depressing.

**What to Expect:**
- Falling leaves (beautiful early autumn)
- Increasing rain
- Strong winds
- Grey skies
- Temperatures dropping

**Clothing:**
- Waterproof jacket (essential)
- Warm layers
- Good shoes (not sneakers)
- Scarf
- Start bringing hat/gloves (November)

**Events:**
- Back to school/work energy
- Cultural season starts
- Sint Maarten (November 11)
- Sinterklaas arrival (mid-November)

### Winter (December-February)

**Character:** Grey and mild. Cold but rarely freezing. Dark.

**What to Expect:**
- 0-7°C mostly
- Snow rare (1-3 times per winter)
- Ice possible
- Very short days (dark by 17:00)
- Grey, grey, grey

**Clothing:**
- Winter coat (windproof, warm)
- Layers underneath
- Warm scarf, hat, gloves
- Waterproof boots
- Bike gloves (cold hands are real)

**Events:**
- Sinterklaas (Dec 5)
- Christmas markets
- New Year celebrations
- Ice skating if it freezes

**SAD Warning:**
Seasonal Affective Disorder common. Strategies:
- Light therapy lamp
- Vitamin D supplements
- Stay active
- Social connections
- Accept and plan for it

## Weather Phenomena

### Rain
- Year-round possibility
- Usually drizzle, not downpour
- Comes suddenly, goes quickly
- Always have rain protection

### Wind
- Constant factor
- Stronger in autumn/winter
- Affects cycling significantly
- Umbrellas often useless (use hood)

### Grey Days (Grauwe Dagen)
- November-February: Overcast majority
- Can go weeks without sun
- Locals accept it
- Affects newcomers' mood

### Rare Events

| Event | Frequency | Impact |
|-------|-----------|--------|
| Snow | 1-3x/year | City stops briefly |
| Ice (Elfstedentocht-level) | Very rare | Skating on natural ice |
| Heat wave (35°C+) | 1-2 weeks/year | No AC, suffer |
| Storms | Several/year | Transport disruption |

## What to Pack/Buy

### Essential Year-Round
- Waterproof jacket with hood
- Layering pieces
- Waterproof bag/backpack
- Umbrella (compact, sturdy)

### Cycling Gear
| Item | Purpose |
|------|---------|
| Rain pants | Keep dry |
| Rain jacket | Essential |
| Bike gloves | Winter warmth |
| Lights | Legal requirement |
| Reflective elements | Visibility |

### Winter Additions
- Thermal underwear
- Warm coat (down or equivalent)
- Waterproof boots
- Hat, scarf, gloves
- Multiple layers

### Summer Additions
- Sunglasses
- Sunscreen
- Light clothing
- Fan (for home)

## Dutch Weather Coping

### Attitude
Dutch don't cancel for weather:
- Rain = still bike
- Wind = still bike
- Cold = add layers, still bike
- Only ice stops cycling

**"Er is geen slecht weer, alleen slechte kleding"**
(There's no bad weather, only bad clothing)

### Outdoor Life Despite Weather
- Terraces have heaters and blankets
- Parks used year-round
- Markets happen rain or shine
- Festivals continue (bring rain gear)

### Indoor Escapes

| Activity | Where |
|----------|-------|
| Museums | DOMunder, Centraal Museum |
| Cafés | Everywhere |
| Libraries | Neude, others |
| Shopping | Hoog Catharijne (covered) |
| Cinemas | Several in center |
| Sports halls | Throughout city |

## Climate Adaptation

### Home Considerations
- Heating: Gas (still common) or heat pump
- Insulation: Check energy label
- Windows: Double glazing minimum
- Ventilation: Dutch homes designed for it

### Energy Costs by Season

| Season | Gas/Electric | Notes |
|--------|--------------|-------|
| Winter | High | Heating main cost |
| Spring/Autumn | Medium | Variable |
| Summer | Low | Minimal heating |

Old, poorly insulated apartments = much higher winter bills.

## Weather Resources

### Apps
- Buienradar — Rain radar (essential)
- KNMI — Official Dutch weather
- Weather apps — General forecasts

### Buienradar Tip
Check before leaving:
- Shows rain approaching by minute
- "Buien" = showers
- Plan your departure between showers

### Websites
- knmi.nl — Official forecasts
- buienradar.nl — Rain radar
- weer.nl — Detailed forecasts

## Seasonal Activities

### Best Weather For

| Activity | Best Time |
|----------|-----------|
| Cycling trips | May-September |
| Terraces | April-September |
| Day trips | Summer |
| Museums | Rainy days |
| Park picnics | June-August |
| Indoor events | November-March |

### Weather-Dependent Events

| Event | Weather Impact |
|-------|----------------|
| King's Day | Pray for sun |
| Festival season | Check forecasts |
| Utrecht Pride | Usually summer (okay) |
| Christmas markets | Cold is atmospheric |

## Comparisons

### vs. Mediterranean
- Much cloudier
- Milder winters
- Much cooler summers
- More rain throughout year

### vs. UK
- Similar climate
- Slightly more continental
- Colder winters
- Similar grey factor

### vs. Scandinavia
- Milder
- Less snow
- Similar grey winters
- Less extreme temperature

## Survival Tips

1. **Accept the weather** — Fighting it makes you miserable
2. **Invest in good rain gear** — Quality waterproofs are worth it
3. **Check Buienradar** — Time your trips between showers
4. **Embrace terrace culture** — Blankets and heaters exist
5. **Get a light therapy lamp** — Winter darkness is real
6. **Vitamin D** — Supplement in winter
7. **Stay active** — Exercise combats seasonal blues
8. **Plan indoor activities** — Don't let weather stop you
9. **Celebrate good days** — When sun appears, drop everything for terraces
