# Utrecht — Starting a Business

## Business Structures

### Overview

| Structure | Dutch Name | For | Liability |
|-----------|------------|-----|-----------|
| Sole proprietor | Eenmanszaak | Freelancers | Personal |
| Partnership | VOF | Partners | Personal |
| Private limited | BV | Growth companies | Limited |
| Foundation | Stichting | Non-profit | Limited |

### Eenmanszaak (Sole Proprietorship)

**Best for:**
- Freelancers
- Consultants
- Simple businesses
- Starting out

**Pros:**
- Easy setup (30 min at KvK)
- Minimal administration
- Tax advantages (startup deductions)
- No minimum capital

**Cons:**
- Personal liability for debts
- Less professional perception
- No distinction owner/business

**Costs:**
- Registration: €75
- Annual: Minimal (accounting)

### VOF (Partnership)

**Best for:**
- Business partners (2+)
- Shared liability acceptable
- Professional services

**Pros:**
- Simple setup
- Flexible profit sharing
- Tax advantages similar to Eenmanszaak

**Cons:**
- Partners liable for each other
- Disputes can be complex
- Personal liability remains

### BV (Private Limited Company)

**Best for:**
- Growth ambitions
- External investment
- Asset protection
- Professional services firms

**Pros:**
- Limited liability
- Professional image
- Easier to sell/transfer
- Better for investment

**Cons:**
- More administration
- Annual accounts required
- Notary required for setup
- Higher accounting costs

**Costs:**
- Setup: €800-2,000 (notary + registration)
- Annual accounting: €1,500-5,000
- Minimum share capital: €0.01 (symbolic now)

### Stichting (Foundation)

**Best for:**
- Non-profit activities
- Cultural organizations
- Charities

**Note:** Cannot distribute profits to founders.

## KvK Registration

### What is KvK?
Kamer van Koophandel (Chamber of Commerce). All businesses must register.

### KvK Utrecht
- Address: Croeselaan 15, 3521 BJ Utrecht
- Hours: Mon-Fri 9:00-17:00
- Appointment required

### Registration Process

**For Eenmanszaak:**
1. Book appointment at kvk.nl
2. Bring ID and address proof
3. Fill forms at office
4. Pay €75
5. Receive KvK number immediately

**For BV:**
1. Notary drafts articles
2. Open bank account with capital
3. Notary registers at KvK
4. More documentation required

### Documents Needed

| Document | Eenmanszaak | BV |
|----------|-------------|-----|
| ID | ✓ | ✓ |
| BSN | ✓ | ✓ |
| Address proof | ✓ | ✓ |
| Business plan | Helpful | Required |
| Notary deed | - | ✓ |
| Bank proof | - | ✓ |

## Taxes for Businesses

### Income Tax (Eenmanszaak)
Your business income = your personal income.
- Progressive rates: 36.97% / 49.5%
- Can deduct business expenses
- Startup deductions available

### Corporate Tax (BV)

| Profit | Rate |
|--------|------|
| Up to €200,000 | 19% |
| Above €200,000 | 25.8% |

Plus dividend tax when extracting profits (26.9%).

### VAT (BTW)

| Rate | Applies To |
|------|------------|
| 21% | Standard rate |
| 9% | Food, books, hotels, some services |
| 0% | Exports, some B2B EU |

**Registration:**
- Mandatory if revenue >€20,000/year
- Quarterly filings (or monthly for larger)
- Via Belastingdienst

### Deductions (Eenmanszaak)

| Deduction | Amount |
|-----------|--------|
| Zelfstandigenaftrek | €5,030 (2026) |
| Startersaftrek | €2,123 (first 3 years) |
| MKB-winstvrijstelling | 13.31% of profit |

These reduce taxable income significantly.

## Freelancing

### Market Reality
- Strong demand for IT, design, marketing
- Rates competitive
- ZZP (freelance) common in NL
- Many work through agencies

### Typical Rates

| Skill | Hourly Rate |
|-------|-------------|
| Junior developer | €50-70 |
| Senior developer | €80-120 |
| IT consultant | €100-150 |
| Designer | €60-100 |
| Marketing | €60-90 |
| Translation | €40-60 |

### Finding Clients
- LinkedIn (essential)
- Freelance.nl
- Headfirst (for larger orgs)
- Networking events
- Direct outreach
- Referrals (best)

### Invoicing
- Charge VAT (add 21% to your rate)
- Payment terms: 14-30 days
- Late payment: Interest allowed
- Keep records for 7 years

## Business Banking

### Requirements
- KvK registration
- Business address
- ID verification
- Some banks require meeting

### Options

| Bank | Monthly Fee | Notes |
|------|-------------|-------|
| ING Business | €10-25 | Full-service |
| ABN AMRO | €10-25 | Full-service |
| Bunq Business | €10-20 | Digital-first |
| Revolut Business | €0-25 | International-friendly |
| N26 Business | €0-10 | Basic |

### Recommendation
- Dutch bank for local credibility
- Bunq/Revolut for ease of setup
- Separate from personal (required for BV)

## Business Insurance

### Recommended

| Insurance | For | Cost/year |
|-----------|-----|-----------|
| Liability (AVB) | Claims against you | €200-500 |
| Professional indemnity | Errors/advice | €300-1,000 |
| Legal expenses | Disputes | €200-400 |
| Disability (AOV) | Income protection | €1,500-4,000 |

### Disability Insurance
- ZZP have no UWV coverage
- If you can't work = no income
- AOV expensive but important
- Alternatives: Broodfonds (collective)

## Administration Requirements

### For Eenmanszaak
- Quarterly VAT returns
- Annual income tax return
- Keep records 7 years
- Simple bookkeeping sufficient

### For BV
- Monthly/quarterly VAT
- Corporate tax returns
- Annual accounts (deposited at KvK)
- Shareholder meetings
- More formal bookkeeping

### Accounting Software

| Software | Price/month | Notes |
|----------|-------------|-------|
| Moneybird | €15-50 | Dutch, popular |
| Exact Online | €30-100 | Comprehensive |
| Informer | €20-40 | Simple |
| Excel | Free | For minimal needs |

## Working from Home

### Allowed
- Most businesses can operate from home
- Check rental contract (some prohibit)
- Some activities need permit

### Tax Deductions
- Part of rent/mortgage
- Utilities proportionally
- Internet, phone
- Office furniture
- Requirements: Dedicated space, regular use

## Finding Office Space

### Options

| Type | Cost/month | Best For |
|------|------------|----------|
| Coworking desk | €150-300 | Freelancers |
| Fixed desk | €250-500 | Regular use |
| Private office | €500-1,500 | Small teams |
| Flex office | €800+ | Growing companies |

### Popular Spaces
- Spaces (premium)
- Tribes (professional)
- Seats2Meet (flexible)
- De Vasim (creative)

## Hiring Employees

### First Hire Complexity
- Dutch employment law strict
- Contracts required
- Social contributions mandatory
- Payroll administration

### Costs Beyond Salary
- Social contributions: ~25% on top
- Pension: 10-15% typically
- Holiday allowance: 8%
- Vacation days: 20+ legal minimum

### Alternatives
- Freelancers (ZZP)
- Payroll services (employer of record)
- Interns (limited, rules apply)

## Support Resources

### KvK Services
- Free business advice
- Workshops and webinars
- Starter's Guide
- Industry information

### UtrechtInc
- Startup programs
- Mentorship
- Investor connections
- Coworking space

### Municipality
- Business support programs
- Permits guidance
- Economic development office

## Permits & Licenses

### Generally Not Needed
Most services and online businesses need no permits.

### May Need Permit
- Food & hospitality
- Childcare
- Healthcare services
- Financial services
- Some retail
- Street trading

### Check
- ondernemersplein.kvk.nl
- Municipality permit office

## Timeline: Starting a Business

### Eenmanszaak (1-2 weeks)
| Step | Time |
|------|------|
| KvK appointment | 1-7 days |
| Registration | Same day |
| Bank account | 1-7 days |
| VAT number | Automatic |
| Start invoicing | Immediately |

### BV (2-4 weeks)
| Step | Time |
|------|------|
| Find notary | 1-3 days |
| Draft articles | 1-2 weeks |
| Open bank, deposit capital | 1 week |
| Notary appointment | 1 day |
| KvK registration | Same day |
| Bank account active | 1-2 weeks |

## Tips

1. **Start as Eenmanszaak** — switch to BV when profitable
2. **Get accountant early** — deductions you'll miss alone
3. **Invoice properly** — VAT, KvK number, payment terms
4. **Separate finances** — business account mandatory for BV
5. **Network actively** — Dutch business runs on relationships
6. **Disability insurance** — you have no safety net as ZZP
7. **Learn basics of Dutch tax** — saves money
8. **Use Belastingdienst resources** — good English info available
