---
name: Utrecht
slug: utrecht
version: 1.0.0
homepage: https://clawic.com/skills/utrecht
description: Navigate Utrecht as visitor, resident, tech worker, student, or entrepreneur with neighborhoods, transport, costs, visas, and local insights.
metadata: {"clawdbot":{"emoji":"🏰","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## When to Use

User asks about Utrecht for any purpose: visiting, moving, working, studying, or starting a business. Agent provides practical guidance with current data.

## Quick Reference

| Topic | File |
|-------|------|
| **Visitors** | |
| Attractions (must-see vs skip) | `visitor-attractions.md` |
| Itineraries (1/3/7 days) | `visitor-itineraries.md` |
| Where to stay | `visitor-lodging.md` |
| Tips & day trips | `visitor-tips.md` |
| **Neighborhoods** | |
| Quick comparison | `neighborhoods-index.md` |
| City Center & Oudegracht | `neighborhoods-center.md` |
| Lombok & Oost | `neighborhoods-multicultural.md` |
| Leidsche Rijn & Vleuten | `neighborhoods-new.md` |
| Tuindorp & Overvecht | `neighborhoods-residential.md` |
| Choosing guide | `neighborhoods-choosing.md` |
| **Food** | |
| Overview & dining scene | `food-overview.md` |
| Local & Dutch | `food-local.md` |
| International & fine dining | `food-international.md` |
| Best areas for dining | `food-areas.md` |
| Dietary, coffee, bars | `food-practical.md` |
| **Practical** | |
| Moving & settling | `resident.md` |
| Transport (trains, trams, bikes) | `transport.md` |
| Cost of living | `cost.md` |
| Safety & laws | `safety.md` |
| Weather & survival tips | `climate.md` |
| Local services (banking, BSN) | `local.md` |
| **Career** | |
| Tech industry & salaries | `tech.md` |
| Business setup & startups | `business.md` |
| Visas (work, HSM, EU Blue Card) | `visas.md` |
| Startups & funding | `startup.md` |
| **Lifestyle** | |
| Culture & customs | `culture.md` |
| Healthcare & insurance | `healthcare.md` |
| Schools & education | `education.md` |
| Expat lifestyle & social | `lifestyle.md` |
| Cycling & transport | `cycling.md` |

## Core Rules

### 1. Identify User Context First
- **Role**: Tourist, resident, tech worker, student, entrepreneur
- **Timeline**: Short visit, planning to move, already there
- Load relevant auxiliary file for details

### 2. Fourth-Largest Dutch City
Utrecht (360,000 pop) is the Netherlands' fourth city but punches above its weight:
- **Central location**: 30 min to Amsterdam by train, geographic center of NL
- **University city**: Utrecht University (30,000+ students) drives culture and innovation
- **Compact and livable**: Everything bikeable, medieval center intact
- **Growing tech scene**: Particularly in gaming, health tech, sustainability

### 3. Housing Reality
Utrecht has one of the tightest housing markets in Europe:
- **Rental wait lists**: Social housing: 10+ year wait
- **Private market**: Extremely competitive, high prices for Dutch standards
- **Expat strategy**: Start searching before moving, consider surrounding towns
- **Budget minimum**: €1,200-1,800/month for studio or small apartment
See `cost.md` for detailed housing breakdown.

### 4. Cycling Culture
Utrecht is a cycling city first:
- **Infrastructure**: World-class bike lanes, world's largest bike parking (Stationsplein)
- **Daily transport**: 60%+ of trips by bicycle
- **Bike rental**: OV-fiets at stations, Donkey Republic app
- **Rules**: Mandatory lights, yield to the right, stick to bike lanes
See `cycling.md` for complete guide.

### 5. Current Data (Feb 2026)

| Item | Range |
|------|-------|
| 1BR rent (Center) | €1,400-2,000/month |
| 1BR rent (Outskirts) | €1,100-1,500/month |
| Senior SWE salary | €5,500-7,500/month gross |
| NS monthly subscription | €350-400 (unlimited train) |
| Dinner mid-range | €25-45/person |
| International school fees | €15,000-25,000/year |

### 6. Dutch Tax System
High taxes, high services:
- **Income tax**: 36.97% up to €75,518, then 49.5%
- **30% ruling**: Expat tax benefit for skilled migrants (30% income tax-free)
- **BTW (VAT)**: 21% standard, 9% reduced (food, hotels)
- **Healthcare mandatory**: Basic insurance ~€130/month + eigen risico (€385 deductible)
See `local.md` for tax details.

### 7. Transit Excellence
Utrecht Central is the Netherlands' busiest train station:
- **NS (trains)**: Direct connections to all major Dutch cities
- **U-OV (tram/bus)**: City and regional network
- **OV-chipkaart**: Universal transit card (essential)
- **Schiphol**: 35 min by train, direct connection
- **Most trips by bike**: Within the city, cycling is faster than any other mode

### 8. Neighborhood Matching

| Profile | Best Areas |
|---------|------------|
| Young professionals | Lombok, Wittevrouwen, city center |
| Families | Tuindorp, Leidsche Rijn, Vleuten, Houten |
| Students | Oost, Lombok, near Uithof campus |
| Budget-conscious | Overvecht, Zuilen, surrounding towns |
| Tech workers | City center (proximity to UtrechtInc, startups) |
| Luxury seekers | Wilhelminapark area, Maliebaan |

## University & Education Hub

Utrecht is first and foremost a university city:
- **Utrecht University**: Top 100 globally, 30,000+ students
- **HKU (University of the Arts)**: Major arts/design school
- **Hogeschool Utrecht**: Applied sciences, 37,000+ students
- **International schools**: Several options in surrounding area

The student population shapes the city's culture: vibrant nightlife, affordable food options, and cycling infrastructure designed for mass daily commutes.

## Dutch-Specific Traps

- **Housing desperation** — Don't transfer money before seeing the property in person. Scams common.
- **Registration required** — You cannot get a BSN (citizen service number) without registered housing.
- **Catch-22** — Many services need BSN, but BSN needs registered address. Plan in advance.
- **Cycling rules** — No lights = €55 fine. Wrong way on bike lane = accident risk.
- **Direct communication** — Dutch directness isn't rude, it's cultural. Don't take offense.
- **Agenda culture** — Dutch plan everything weeks ahead. Spontaneous visits are rare.
- **Store hours** — Many shops closed Sundays and Mondays. Supermarkets more flexible.
- **Tipping minimal** — 5-10% is generous. Rounding up is common and acceptable.
- **Weather layers** — Dress in layers year-round. Rain can start anytime.
- **Bike theft** — Two locks minimum. Expensive bikes attract thieves.

## Legal Awareness

Key laws visitors/residents must know:
- **Soft drugs**: Cannabis technically illegal but tolerated in licensed coffeeshops (not common in Utrecht compared to Amsterdam)
- **Hard drugs**: Zero tolerance. Possession/sale is criminal offense.
- **Alcohol**: Legal at 18. No public intoxication.
- **Cycling infractions**: Fines for no lights (€55), wrong way (€95), phone use (€140)
- **ID requirement**: Must carry ID if 14+. €95 fine if unable to identify.
- **Noise regulations**: Strict, especially in residential areas. Neighbors will complain.
- **Tenant rights**: Strong protections, but landlord disputes common for expats.

See `safety.md` for comprehensive legal guidance.

## Related Skills
Install with `clawhub install <slug>` if user confirms:

- `dutch` — Dutch language learning and practice
- `travel` — Travel planning and trip organization
- `career` — Career development and job search
- `freelance` — Freelancing guidance and contracts
- `plan` — General planning and goal setting

## Feedback

- If useful: `clawhub star utrecht`
- Stay updated: `clawhub sync`
