# Stress Management and Wellbeing

## USMLE-Specific Stressors

### The Pressure
- Medical students are high-achievers in high-pressure environment
- Step scores affect specialty choice and residency match (especially Step 2 CK)
- Comparison culture is toxic (avoid SDN forums during dedicated)
- IMGs face additional pressure: score competitiveness is even more critical

### Dedicated Period Challenges
- 4-8 weeks of isolation
- Loss of routine (no classes/clinical duties)
- Financial pressure (exam fees, resources)
- Sleep disruption from anxiety

## Warning Signs

### Burnout Indicators
- Declining question bank scores despite studying
- Unable to focus for full blocks
- Dreading study sessions
- Physical symptoms (headaches, GI issues, insomnia)
- Isolation from friends/family

### When to Take Action
- Score drops >5 points on practice tests
- Skipping multiple study days
- Emotional outbursts or numbness
- Suicidal ideation (seek help immediately)

## Prevention Strategies

### Daily
- Set a hard stop time (e.g., no studying after 8 PM)
- Take all breaks during practice tests (build the habit)
- One physical activity (walk, gym, sports)
- Eat real meals (not just snacks at desk)
- Sleep 7-8 hours (non-negotiable)

### Weekly
- One full rest day (or at least half-day)
- Social interaction (even brief)
- Hobby time (music, games, whatever decompresses)
- Review progress to see improvement

### Throughout
- Limit social media (especially med school forums)
- Have an accountability partner (friend, tutor, therapist)
- Remember: one exam does not define your career

## Resources

### Mental Health
- Student counseling services (free at most schools)
- Dr. Lotte (physician-focused therapy)
- Talkspace/BetterHelp (teletherapy options)
- Crisis lines if needed

### Perspective
- The vast majority of test-takers pass
- Step 1 is now P/F — the game has changed
- Many successful physicians had setbacks in training
- Matching is about the whole application, not just scores

## If You've Failed

### Normalize It
- ~5-10% of test-takers fail Step 1
- Most who retake pass on the second attempt
- It's a setback, not the end

### Next Steps
1. Take time to process emotionally (1-2 weeks minimum)
2. Request detailed score report
3. Identify what went wrong (content vs test-taking vs burnout)
4. Create different study plan (not same approach)
5. Set realistic retake timeline (3-6 months)
6. Consider tutoring or structured program
