# User Type Adaptations

## US MD Student

### Profile
- In accredited US medical school
- Structured curriculum with dedicated study periods
- Access to school resources (tutors, counseling, NBME discounts)
- Timeline integrated with clerkships and ERAS

### Agent Focus
- Optimize around school schedule and clerkship rotations
- Track shelf exam performance as Step 2 CK predictor
- Integrate with school's academic support if struggling
- Standard dedicated period planning (4-8 weeks)

### Special Considerations
- Step 1 is P/F so focus is on passing, not maximizing score
- Step 2 CK timing should account for ERAS application (September)
- Clinical grades matter more now that Step 1 is P/F

---

## US DO Student

### Profile
- In osteopathic medical school
- May take COMLEX-USA in addition to USMLE
- Some programs require both, others USMLE only
- Same timeline as US MDs for match

### Agent Focus
- Dual-exam strategy if taking both COMLEX and USMLE
- Allocate prep time between both exams or consolidate
- Track which residency programs require/prefer USMLE
- OMM integration for COMLEX (not needed for USMLE)

### Special Considerations
- COMLEX Level 1 and Step 1 overlap significantly
- Many students take Step 1 a few weeks after COMLEX Level 1
- For competitive specialties, USMLE is often preferred/required

---

## IMG (International Medical Graduate)

### Profile
- Graduated from medical school outside US/Canada
- Requires ECFMG certification for residency
- Score competitiveness is higher (need strong numbers to match)
- May lack US clinical experience

### Agent Focus
- **Maximize Step 2 CK score** — this is the primary differentiator
- Plan US clinical experiences (USCEs) around exam prep
- ECFMG certification pathway tracking
- Realistic specialty targeting based on IMG match data

### Special Considerations
- IMGs need higher scores to compensate for lack of US network
- Clinical experience letters from US physicians are critical
- Consider applying broadly (many programs, many regions)
- Research can partially compensate for lower scores
- Step 1 P/F helps — eliminates one score comparison point

---

## Retaker

### Profile
- Previously failed Step 1 or Step 2 CK
- May have identified what went wrong (or not)
- Often has time pressure (re-application, career delays)
- Higher burnout risk and emotional burden

### Agent Focus
- **Analyze previous failure**: content gaps vs test-taking vs burnout
- Different resources if previous approach didn't work
- Shorter, targeted study plan (not full restart)
- Psychological support and shame-free tracking
- Question interpretation and pacing drills

### Special Considerations
- Fresh question bank needed (seen questions won't help as much)
- Consider tutoring or structured retake program
- Be honest about readiness before rescheduling (don't rush)
- Connect with other retakers for support (you're not alone)
- Many retakers pass on second attempt with adjusted approach

---

## Working/Non-Traditional

### Profile
- Not in traditional student schedule
- May be working full-time while studying
- Limited hours available (evenings, weekends)
- Extended timeline needed

### Agent Focus
- Realistic daily hour targets (2-4 hours vs 8-10)
- Extended timeline (6-12 months vs 4-8 weeks)
- High-yield focus (can't cover everything)
- Weekend intensive blocks
- Flexible scheduling around work

### Special Considerations
- Quality over quantity (focused 2 hours > distracted 6 hours)
- Anki can be done during commute or breaks
- Practice tests on weekends (protected full-day blocks)
- May need to negotiate time off for dedicated period

---

## Parent/Coach

### Profile
- Supporting someone preparing for USMLE
- Needs visibility into progress without micromanaging
- May not understand medical content
- Wants to help without adding pressure

### Agent Focus
- Progress summaries in plain language
- Red flag alerts (declining scores, skipped days)
- Suggested ways to support (meals, errands, encouragement)
- When to intervene vs when to give space
- Resource on burnout signs

### Special Considerations
- Medical school is intense — some stress is normal
- Don't compare to other students or siblings
- Celebrate small wins
- Know when professional help is needed
