# Progress Tracking System

## What to Track

### Daily Metrics
- Hours studied (active vs passive)
- Questions completed (new vs review)
- Percent correct (overall and by system)
- Anki cards reviewed
- Topics covered

### Weekly Metrics
- UWorld/Amboss block averages
- System-wise breakdown
- Time per question trends
- Flagged questions reviewed

### Assessment Milestones
- NBME practice exam scores (with date and conditions)
- UWorld Self-Assessment (UWSA) scores
- Free 120/Sample questions performance
- Predicted score calculations

## Question Bank Tracking

### UWorld
- Track % complete overall
- Track % correct by organ system
- Track % correct by discipline (Pathology, Pharmacology, etc.)
- Maintain "Marked" queue for review
- Track "Incorrect" queue completion

### Amboss (if used)
- Separate tracking from UWorld
- Compare difficulty ratings
- Cross-reference weak systems

## Score Prediction

### For Step 1 (historical, pre-P/F era)
| Practice Test | Predicted Score |
|---------------|-----------------|
| UWSA1 | Overpredicts by ~10-15 points |
| UWSA2 | Most accurate, ±5 points |
| NBME | Usually underpredicts by ~5-10 |
| Free 120 | % correct × ~2.5 ≈ predicted |

### For Step 2 CK
| Practice Test | Predicted Score |
|---------------|-----------------|
| UWSA2 | Most accurate predictor |
| NBME forms | Variable, depends on form |
| UWorld % | 70% → ~240, 80% → ~255 (rough) |

## Weakness Identification

### Flag questions by:
- Content gap (didn't know the material)
- Application error (knew content, applied wrong)
- Careless mistake (calculation, misread)
- Time pressure (ran out of time)

### System-Level Analysis
When a system shows <60% correct:
1. Review First Aid section thoroughly
2. Watch relevant B&B/Pathoma videos
3. Do Anki deck for that system
4. Return to question bank for that system only

## Readiness Indicators

### Ready to test:
- UWorld % consistently >70%
- NBME within 10 points of target
- No system below 55%
- Completed at least 80% of UWorld once
- Taken at least 2 practice NBMEs

### Not ready:
- Large swings between practice tests (>15 points)
- Multiple systems below 50%
- Less than 60% UWorld complete
- Trending downward on assessments
