# Residency Targeting

## Step 2 CK Score Expectations by Specialty

Since Step 1 is now Pass/Fail, Step 2 CK has become the primary screening metric.

### Highly Competitive (260+)
- Dermatology
- Plastic Surgery
- Orthopedic Surgery
- Neurosurgery
- ENT (Otolaryngology)
- Interventional Radiology

### Competitive (250-259)
- Ophthalmology
- Radiation Oncology
- General Surgery (top programs)
- Urology
- Anesthesiology (top programs)

### Moderate (240-249)
- Internal Medicine (academic)
- Emergency Medicine
- Radiology (diagnostic)
- Obstetrics/Gynecology
- Neurology
- Psychiatry

### Less Score-Dependent (230+)
- Family Medicine
- Pediatrics
- Internal Medicine (community)
- Pathology
- Physical Medicine & Rehabilitation

## IMG Considerations

### Score Requirements
IMGs generally need HIGHER scores than US MDs/DOs:
- Competitive specialties: 250+ minimum, 260+ preferred
- Moderate specialties: 240+ minimum
- IMG-friendly specialties: 230+

### IMG-Friendly Specialties
- Internal Medicine
- Family Medicine
- Pediatrics
- Pathology
- Psychiatry
- Neurology

### Additional Requirements
- ECFMG certification
- US clinical experience (USCEs) — critical
- Strong letters of recommendation from US physicians
- Research (especially for competitive specialties)

## Match Timeline

### For US MDs/DOs

| Milestone | Timing |
|-----------|--------|
| Step 1 | End of M2 |
| Core clerkships | M3 |
| Step 2 CK | M3 or early M4 |
| ERAS opens | September M4 |
| Interviews | October-January |
| Rank lists due | February |
| Match Day | March |

### For IMGs

| Milestone | Timing |
|-----------|--------|
| Step 1 | Before clinical rotations |
| Step 2 CK | ASAP after Step 1 |
| USCEs | 3-6 months minimum |
| ECFMG certification | Before ERAS |
| ERAS application | September |
| Match | Same as US graduates |

## Score Goal Setting

### Realistic Goal Formula
1. Take baseline NBME
2. Add 15-20 points for dedicated improvement
3. Compare to specialty average
4. Adjust timeline if gap is large

### When to Adjust Expectations
- If baseline is 40+ points below specialty average: consider backup specialties
- If strong upward trend: may exceed initial goal
- If research/letters are exceptional: scores slightly less critical

## Competitiveness Calculator

Factors beyond Step 2 CK:
- Step 1 pass (yes/no)
- Clinical grades (Honors preferred for competitive)
- Letters of recommendation (strength and specialty match)
- Research (publications, presentations)
- Personal statement
- Geographic ties
- Interview performance
