# Study Methods and Resources

## Core Resources

### Step 1
| Resource | Purpose | Priority |
|----------|---------|----------|
| UWorld | Questions, explanations | Essential |
| First Aid | Review book, annotations | Essential |
| Pathoma | Pathology videos + book | High |
| Sketchy Micro/Pharm | Visual mnemonics | High |
| Boards & Beyond | Video lectures | Medium-High |
| Anki (AnKing) | Spaced repetition | Essential |

### Step 2 CK
| Resource | Purpose | Priority |
|----------|---------|----------|
| UWorld | Questions, clinical reasoning | Essential |
| OME (Online Med Ed) | Video lectures | High |
| Amboss | Questions + library | Medium-High |
| Step Up to Medicine | Internal medicine | Medium |
| Divine Intervention | Podcasts | Popular |

## Study Strategies

### Question-Based Learning (Recommended)
1. Do 40-80 questions daily in timed, random mode
2. Review ALL explanations (right and wrong answers)
3. Annotate First Aid with UWorld pearls
4. Make Anki cards for concepts you miss repeatedly
5. Never read passively without questions

### Dedicated Study Period
**Step 1**: 4-8 weeks full-time
- 2 UWorld blocks (80 questions) daily
- 2-3 hours of targeted review (videos, reading)
- Anki reviews daily (can be 1-2 hours)
- NBME practice test every 1-2 weeks

**Step 2 CK**: 4-6 weeks full-time (or longer if during clerkships)
- Similar structure but clinical focus
- Shelf exams during clerkships build foundation

### Spaced Repetition (Anki)
- AnKing deck has ~28,000 cards tagged to First Aid/Pathoma/Sketchy
- Unsuspend cards as you cover topics
- DO NOT skip daily reviews
- Mature cards = 90%+ retention
- If behind, use filtered decks to catch up

## Common Mistakes

### Study Errors
- Reading First Aid cover-to-cover without questions (passive)
- Saving UWorld until dedicated (should start early)
- Doing questions in tutor mode only (must practice timing)
- Not reviewing wrong answers thoroughly
- Neglecting Anki reviews

### Test-Taking Errors
- Changing answers without good reason
- Spending too long on hard questions
- Not reading question stems carefully (second-order)
- Panicking on unfamiliar topics (there will be ~10%)
- Poor break utilization

## Practice Test Schedule

### Suggested timing (Step 1/2 CK):
- 6 weeks out: Baseline NBME
- 4 weeks out: NBME + UWSA1
- 2 weeks out: NBME + UWSA2
- 1 week out: Free 120
- Final week: Light review, no new content

### Red flags to delay exam:
- NBME trending down
- >10 points below target on UWSA2
- Burnout symptoms (declining performance, can't focus)
