# User Cognitive Profiles

🤖🤝🧠 Discover your communication patterns with AI

## Overview

This OpenClaw skill analyzes your ChatGPT conversation history to identify **cognitive archetypes** — recurring patterns in how you think, communicate, and collaborate with AI.

## Quick Start

1. **Export your ChatGPT data:**
   - ChatGPT → Settings → Data Controls → Export Data
   - Download the ZIP from your email
   - Extract to get `conversations.json`

2. **Install dependencies:**
   ```bash
   pip3 install -r requirements.txt
   ```

3. **Run analysis:**
   ```bash
   python3 scripts/analyze_profile.py \
     --input conversations.json \
     --output my-profile.json \
     --archetypes 3
   ```

4. **Apply insights:**
   - Review `my-profile.json`
   - Add relevant insights to your `SOUL.md` or `AGENTS.md`

## Files

- `SKILL.md` — Full documentation
- `scripts/analyze_profile.py` — Analysis tool
- `examples/` — Sample profiles and configurations
- `references/` — Technical methodology

## License

MIT
