# User Cognitive Profiles - Skill Package

## 📦 Package Contents

```
user-cognitive-profiles/
├── SKILL.md                          # Main documentation (10k+ words)
├── README.md                         # Quick start guide
├── LICENSE                           # MIT License
├── requirements.txt                  # Python dependencies
├── .gitignore                        # Git ignore rules
│
├── scripts/
│   ├── analyze_profile.py            # Main analysis tool (600+ lines)
│   └── compare_profiles.py           # Profile comparison tool
│
├── examples/
│   ├── custom-archetypes.yaml        # Example custom archetypes
│   └── sample-profile.json           # Example output
│
└── references/
    └── methodology.md                # Technical documentation
```

## 🚀 Ready for ClawHub

This skill is complete and ready for upload to https://www.clawhub.ai/upload

### Files to Upload:
1. ✅ SKILL.md (comprehensive documentation)
2. ✅ README.md (quick start)
3. ✅ scripts/analyze_profile.py (main tool)
4. ✅ scripts/compare_profiles.py (comparison tool)
5. ✅ examples/ (sample configs and outputs)
6. ✅ references/methodology.md (technical details)
7. ✅ requirements.txt (dependencies)
8. ✅ LICENSE (MIT)

## ✨ Key Features

### 🤖 Core Functionality
- Analyzes ChatGPT conversation exports
- Identifies cognitive archetypes using clustering
- Detects context-switching patterns
- Generates actionable recommendations
- Supports custom archetype definitions

### 🧠 Archetype Detection
Built-in archetypes:
- **Systems Architect** — Detailed, analytical, strategic
- **Efficiency Optimizer** — Brief, direct, action-oriented
- **Philosophical Explorer** — Meaning-seeking, deep questions
- **Creative Synthesizer** — Pattern-recognizing, analogical
- **Collaborative Partner** — Interactive, co-creative

Custom archetypes supported via YAML config.

### 📊 Output Formats
- **JSON** — Full structured profile
- **Prompt Snippet** — Ready-to-use agent configuration

### 🔒 Privacy First
- All processing is local
- No data uploaded to external services
- You control what gets shared

## 📝 Usage Examples

### Basic Analysis
```bash
python3 scripts/analyze_profile.py \
  --input conversations.json \
  --output profile.json
```

### Custom Archetypes
```bash
python3 scripts/analyze_profile.py \
  --input conversations.json \
  --archetypes-config my-archetypes.yaml
```

### Compare Over Time
```bash
python3 scripts/compare_profiles.py \
  profile_jan.json profile_jun.json
```

## 🎯 Use Cases

1. **Optimize OpenClaw Agent** — Configure SOUL.md based on detected patterns
2. **Improve AI Communication** — Understand your own style preferences
3. **Team Onboarding** — Help new team members configure their agents
4. **Track Evolution** — See how your communication changes over time

## 📈 Technical Highlights

- **Clustering:** K-Means with scikit-learn (fallback for no dependencies)
- **Features:** 5 dimensions (length, questions, code, turns, keywords)
- **Validation:** Confidence scores based on cluster size
- **Extensibility:** Custom archetypes via YAML
- **Performance:** Handles 10k+ conversations efficiently

## 🧪 Testing

Tested with:
- ✅ Python 3.8+
- ✅ ChatGPT conversation exports
- ✅ Various conversation volumes (100 - 10k)
- ✅ Both sklearn and fallback modes

## 🎨 Design Philosophy

**Cross-domain insight:** This tool treats human-AI communication like **acoustic resonance** — the same "signal" (information) lands differently depending on the "harmonics" of the receiver. By detecting your cognitive "frequency," the AI can tune its responses for maximum clarity and utility.

## 📝 Submission Notes

**Skill Name:** `user-cognitive-profiles`
**Emoji:** 🤖🤝🧠
**Category:** Communication / User Research / Optimization
**License:** MIT

**Key Differentiator:** Unlike generic "personality" tools, this analyzes *actual behavior* (your conversations) rather than self-reported preferences. It's empirical, not theoretical.

---

**Status:** ✅ READY FOR UPLOAD
