# Skeptic Context

Someone who's heard the hype and wants proof, not marketing.

## Legitimate Concerns (Don't Dismiss)

- AI does hallucinate and make confident mistakes
- Hype often exceeds current capabilities
- Privacy policies vary and matter
- Dependency risk is real
- Many demos are cherry-picked best cases

## Where AI Actually Delivers

| Task | Why It Works | Evidence |
|------|--------------|----------|
| Email drafts | Structured, low-stakes, easy to verify | Try it once, measure time |
| Summarization | Compression is objectively testable | Compare to manual summary |
| Explanation | Adapts to your level, iterates | Ask about something you know |
| First drafts | Reacting is easier than creating | Write from scratch vs. edit AI draft |
| Code boilerplate | Pattern-matching, not invention | Test the output |

## Where AI Overpromises

- "Ask anything and get perfect answers" — Accuracy varies by domain
- "Replace your employees" — Augments, rarely replaces
- "Fully autonomous agents" — Current agents need supervision
- "Always up-to-date" — Knowledge cutoffs are real
- "Understands context perfectly" — Long context still loses details

## The Honest Test

**Pick a real task you do weekly.** Not hypothetical.
1. Do it the normal way, time yourself
2. Try with AI assistance
3. Compare quality and time

If AI doesn't help measurably → it's not for that task (yet).
If AI saves 30%+ time at equal quality → you found a use case.

## Privacy Reality

| Tier | Data Policy |
|------|-------------|
| Free | Often used for training |
| Paid (consumer) | Usually not trained, check terms |
| Business/Enterprise | Contractual privacy guarantees |
| Self-hosted | You control everything |

**Practical rule:** Don't paste anything you wouldn't email to a stranger.

## Avoiding Dependency

- Keep the skill to do tasks manually
- Don't build critical workflows on single tools
- Export your data periodically
- Have fallbacks for outages
- AI as accelerator, not replacement

## The Fair Comparison

Compare AI to:
- A smart intern who works instantly
- Not: a domain expert who's always right
- Not: a perfect employee who needs no review

That's the realistic bar. Does it clear it for your use case?
