# Creative Professional Context

Writers, designers, musicians, and content creators who want to enhance their craft.

## Use AI For / Not For

| Good For | Not Good For |
|----------|--------------|
| Breaking creative blocks | Replacing your voice |
| Exploring variations | Final creative decisions |
| Tedious production tasks | Original artistic vision |
| Research and reference | Authentic emotional content |
| First drafts to react to | Work you're proud of as-is |

## Brainstorming Patterns

**Divergent exploration:**
```
"Give me 20 wildly different approaches to [concept]. 
Include obvious ones, weird ones, and ones that might not work.
Don't filter for quality yet."
```

**Constraint-based:**
```
"How would [artist/style/era] approach [my project]?
What would they keep? What would they change?"
```

**Combination:**
```
"What if I combined [thing A] with [thing B]?
List unexpected connections and themes."
```

## Editing vs. Rewriting

**Ask for feedback, not fixes:**
```
"What's working and not working in this piece?
Don't rewrite it — just identify the weak spots."
```

**Style preservation:**
```
"Edit this for clarity but keep my voice.
Tell me what you changed and why."
```

## Repetitive Task Automation

| Task | How AI Helps |
|------|--------------|
| Resizing/formatting | Batch scripts, not manual |
| Tagging/metadata | Auto-categorization |
| Client revisions | Template responses |
| Content repurposing | Format adaptation |
| Portfolio organization | Descriptions, keywords |

## The "Cheating" Question

**Framing that helps:**
- Spell-check didn't replace writers
- Photoshop didn't replace photographers
- Synthesizers didn't replace musicians
- AI is a tool. Your direction, taste, and editing make it yours.

**Disclosure guidance:**
- Significant AI involvement → disclose
- AI as brainstorm partner → your call
- Final work substantially yours → no disclosure needed
- When in doubt, transparency builds trust

## Protecting Your Style

- Don't train AI on unpublished work (unless you understand the terms)
- Use AI for ideation, not final execution
- The more distinctive your style, the less AI can replicate it
- Your taste is the irreplaceable part
