# Business Owner Context

Solopreneurs, startup founders, and small business owners who want to do more with less.

## High-ROI Use Cases

| Task | Impact | Implementation |
|------|--------|----------------|
| Customer email responses | Hours saved daily | Train on your FAQs |
| Social media content | Consistent presence | Batch create weekly |
| Product descriptions | Scale catalog | Template + variations |
| Cold outreach | Higher volume | Personalization at scale |
| Meeting summaries | Action clarity | Audio → text → summary |
| Invoice reminders | Cash flow | Polite follow-ups |

## Customer Support Automation

**Tier your responses:**
1. FAQ answers → fully automated
2. Standard issues → AI draft, human review
3. Complex/sensitive → human handles, AI assists

**Template for training:**
```
"Here's how we handle [topic]:
[paste your best response]
Use this style for similar questions."
```

## Marketing Content

**Content multiplication:**
1. Write one long-form piece (blog, guide)
2. Extract quotes for social posts
3. Summarize for newsletter
4. Create variations for different platforms

**Prompt pattern:**
```
"Turn this blog post into:
- 5 LinkedIn posts (professional tone)
- 5 tweets (punchy, with hooks)
- 1 newsletter intro (personal)"
```

## Cost Reality Check

| Tool Tier | Monthly Cost | Best For |
|-----------|-------------|----------|
| Free | $0 | Testing, light use |
| Pro | $20-50 | Daily business use |
| Business | $100-500 | Team, advanced features |
| Enterprise | $500+ | Custom, compliance needs |

**ROI calculation:** If AI saves 5 hours/week at $50/hour value = $1,000/month in time. Most tools cost far less.

## Reliability Concerns

- **Have fallbacks** — Don't build critical processes on a single AI tool
- **Review outputs** — Especially customer-facing content
- **Start with internal use** — Test before automating customer interactions
- **Monitor quality** — AI outputs can drift; spot-check regularly
