---
name: Use Cases
description: "Discover what AI agents can do for you with practical examples by role, task type, and skill level."
---

## Who This Is For

Someone asking "what can this actually do?" Start by identifying their context.

| Signal | They are... | Load |
|--------|-------------|------|
| "Just heard about AI", "is this useful for me?" | Beginner | `contexts/beginner.md` |
| Emails, reports, meetings, spreadsheets | Office professional | `contexts/professional.md` |
| Code, debugging, CI/CD, APIs | Developer | `contexts/developer.md` |
| Customer support, marketing, operations | Business owner | `contexts/business.md` |
| Writing, design, music, content | Creative | `contexts/creative.md` |
| "Show me something real", "not gimmicks" | Skeptic | `contexts/skeptic.md` |

---

## High-Value Use Cases (Universal)

**Communication:**
- Draft emails matching tone to recipient
- Summarize long threads before meetings
- Write difficult messages (rejections, negotiations, complaints)

**Information Processing:**
- Summarize documents, articles, reports
- Extract key points from meeting recordings
- Explain complex topics in simple terms

**Writing & Editing:**
- First drafts from bullet points
- Proofreading with style preservation
- Translation with context awareness

**Analysis:**
- Make sense of spreadsheet data
- Compare options with pros/cons
- Research topics and synthesize findings

**Learning:**
- Explain concepts at your level
- Practice conversations (languages, interviews)
- Get feedback on your work

---

## What AI Cannot Do

Be upfront about limitations:

- **No real-time information** — Data has a cutoff date
- **No memory across sessions** — Unless explicitly configured
- **Can hallucinate** — Always verify facts, especially names, dates, URLs
- **No execution** — Can't send emails, buy things, or take actions (unless integrated)
- **No judgment** — Final decisions remain yours

---

## Addressing Common Concerns

**"Is my data safe?"**
→ Depends on the tool. Check privacy policy. Enterprise tiers often don't train on your data. Don't paste passwords or API keys.

**"Will it replace my job?"**
→ AI augments, not replaces. People who use AI outperform those who don't. Learn to work with it.

**"How do I know it's accurate?"**
→ Verify outputs. Use AI for drafts and ideas, not final truth. Cross-check important facts.

**"Is using AI cheating?"**
→ It's a tool. Spell-check didn't replace writers. The work is still yours if you direct, review, and refine.

---

## Getting Started (For Beginners)

1. **Start small** — One task you do weekly that's tedious
2. **Be specific** — "Write a professional email declining a meeting" works better than "help me"
3. **Iterate** — First response rarely perfect. Say "make it shorter" or "more formal"
4. **Verify** — Don't send/use AI output without reviewing it

---

## Discovery Questions

When someone doesn't know what to ask for:

- "What task do you dread doing every week?"
- "Where do you spend time that doesn't feel valuable?"
- "What would you do if you had an assistant who never slept?"
- "What's something you'd love to do but don't have time for?"

Their answers reveal high-value use cases.
