# US Value Investing Framework — Extended Guide

## 1) Thesis architecture

Use a 5-line thesis:
1. Business quality
2. Durable advantage (moat)
3. Valuation gap
4. Re-rating trigger
5. Main invalidation condition

## 2) Data fields (minimum)

- Revenue CAGR (3Y)
- FCF CAGR (3Y)
- ROIC
- Gross margin
- FCF margin
- Net debt / EBITDA
- PE (NTM or TTM)
- EV/EBIT
- FCF yield
- Optional fair value estimate

## 3) Expanded qualitative checks

### Moat scoring (0-10)
- Switching costs
- Network effects
- Brand/IP
- Cost advantage
- Distribution lock-in

### Management scoring (0-10)
- Capital allocation discipline
- Buyback/dividend quality
- Guidance credibility
- Incentive alignment

## 4) Valuation logic

Use multiple lenses instead of a single ratio:
- Relative: PE/EV-EBIT vs own history
- Cash lens: FCF yield vs rates and peers
- Scenario lens: base/bull/bear valuation range

## 5) Decision policy

- Buy: score >=75 and no red-line risk
- Watch: score 60-74 or valuation not attractive enough
- Avoid: score <60 or red-line risk present

## 6) Position sizing hints

- High conviction: 4-8%
- Medium conviction: 2-4%
- Tracking: 0.5-2%

Never override risk budget because of narrative excitement.

## 7) Output template (English-first + Chinese summary)

### EN
- Thesis
- Score breakdown
- Risks
- Action and trigger levels

### 中文结论（摘要）
- 一句话结论
- 关键分数与估值区间
- 触发买入/减仓条件
