---
name: us-value-investing-framework
description: US stock valuation model skill (English-first + 中文) based on financial report data. Use when you need to apply explicit rules: ROE > 15% for 3+ years, debt ratio < 50%, free cash flow > 80% of net income, moat assessment (brand/network effect/cost advantage), then output investment rating (A/B/C/D) with reasons.
---

# US Stock Valuation Model - Value Investing Framework (EN + 中文)

This skill is an explicit rule-based value model focused on US stocks.

## Input

Company financial report data (structured JSON), including:
- 3+ years of ROE
- Debt ratio
- Free cash flow and net income
- Moat assessment: brand / network effect / cost advantage

Use the bundled template: `references/input-template.json`.

## Decision Rules (strict)

1. **ROE rule**: ROE > 15% for at least 3 consecutive years
2. **Leverage rule**: Debt ratio < 50%
3. **Cash conversion rule**: Free cash flow > 80% of net income
4. **Moat rule**: evaluate brand/network effect/cost advantage

## Output

- Investment rating: **A / B / C / D**
- Reasons (pass/fail explanation per rule)
- Bilingual summary (EN main + 中文摘要)

## Run

```bash
python3 scripts/evaluate_company.py \
  --input references/input-template.json \
  --out .state/eval.json \
  --markdown .state/eval.md
```

## Rating policy

- **A**: all 4 rules pass
- **B**: 3 rules pass
- **C**: 2 rules pass
- **D**: 0-1 rule pass

## Resources

- `scripts/evaluate_company.py`: deterministic evaluator
- `references/input-template.json`: input schema example
