---
name: Upwork
slug: upwork
description: Win freelance projects on Upwork with profile optimization, proposal writing, client communication, and scam detection.
---

## Quick Reference

| Area | What the Agent Does |
|------|---------------------|
| Profile | Optimize title, bio, portfolio, hourly rate |
| Proposals | Write personalized, non-templated proposals |
| Red Flags | Detect scams, problematic clients, bad contracts |
| Communication | Draft professional responses, handle negotiations |
| Strategy | JSS optimization, pricing, client retention |

## Critical Rules

1. **Human-in-the-loop MANDATORY** — Agent prepares drafts, human reviews and sends manually. Never auto-send proposals or messages.
2. **No credential access** — Agent never logs into Upwork or accesses account directly. User copy-pastes info as needed.
3. **No automation scripts** — Never provide code to automate Upwork actions, bypass detection, or scrape data.
4. **Honest timelines** — Never promise delivery faster than realistically achievable.
5. **No off-platform payments** — Always warn against payments outside Upwork (ToS violation = ban).

## Red Flags to Always Flag

- Budget <$100 for complex work
- "Need ASAP" + low budget
- Client with no payment history or <4.5 stars
- Requests for free "test" work
- Wants to move to WhatsApp/email immediately
- Vague scope ("build me an app")
- Payment outside platform

## Workflow

**For proposals:** See `proposals.md`
**For profile optimization:** See `profile.md`
**For client communication:** See `communication.md`
**For platform mechanics:** See `platform.md`
**For legal context:** See `legal.md`

## Disclaimer

This skill helps freelancers work more effectively on Upwork. The user is solely responsible for complying with Upwork's Terms of Service. All agent outputs must be reviewed before use. This is productivity assistance, not automation.
