# Upwork Hunting — Find, Bid, Win Automation Jobs

Systematically find and win Upwork jobs using our n8n workflow library (2,061 templates) as a speed advantage.
All outputs go to `workspace/artifacts/`.

## Use when
- Scanning Upwork for jobs to bid on
- Writing proposals for n8n/automation/AI agent jobs
- Evaluating whether a job is worth a connect spend
- Estimating delivery time using our template library
- Positioning ourselves against other freelancers

## Don't use when
- Writing the actual proposal copy (use proposal-writing skill)
- Handling client objections after bidding (use objection-handling skill)
- Doing discovery after winning (use client-discovery skill)
- Jobs outside our domain (graphic design, copywriting, mobile dev)

## Negative examples
- "Help me build an n8n workflow" → No. This is for FINDING jobs, not doing them.
- "Write me a portfolio piece" → No. Different task.
- "Should I raise my rate?" → No. Use pricing-psychology skill.

## Edge cases
- Fixed-price vs hourly evaluation → YES. This skill covers both.
- "Is this job a scam?" → YES. Red flag detection included.
- Jobs that need n8n + custom code → YES. Evaluate if template + light code is feasible.

---

## Our Competitive Edge

We have what most Upwork freelancers don't:

1. **2,061 n8n workflow templates** (~/projects/n8n-workflows/) — we customize, not build from scratch
2. **Live n8n instance** at localhost:5678 — can demo instantly
3. **Twilio already configured** — SMS/voice jobs are plug-and-play
4. **AI/LLM expertise** — OpenAI, Ollama, agent orchestration
5. **Full sales pipeline skills** — discovery, proposals, objections, retention

**Speed advantage:** A job that takes most freelancers 8-10 hours, we deliver in 2-4 hours using templates.

---

## Job Targeting Criteria

### Ideal Job Profile (Bid Aggressively)
- **Category:** n8n automation, workflow automation, API integration, AI chatbot
- **Budget:** $200-2,000 fixed price OR $30-75/hr hourly
- **Posted:** <48 hours ago
- **Proposals:** <15 submitted
- **Client:** Verified payment, $1K+ spent, 4.5+ rating
- **Scope:** Clearly defined deliverable
- **Template match:** We have 70%+ of the workflow in our library

### Good Job Profile (Bid Selectively)
- **Budget:** $100-200 (small but fast win for reviews)
- **Posted:** 2-5 days ago with <20 proposals
- **Scope:** Slightly vague but in our domain
- **Client:** New to Upwork but verified payment

### Avoid (Don't Waste Connects)
- Budget under $50 (not worth the time)
- 50+ proposals already (too competitive)
- "Build me an app" with $100 budget (unrealistic expectations)
- No payment verification
- Vague scope with no budget range
- "Looking for long-term, pay is low but will increase" (it won't)

---

## Job Categories We Can Dominate

### Tier 1: Template-Ready (1-3 hours delivery)
These map directly to our n8n library. Bid aggressively.

| Job Type | Our Template Source | Connects to Spend |
|----------|-------------------|-------------------|
| Slack/Discord → CRM sync | workflows/Slack + workflows/Hubspot | 4-6 |
| Form → email + sheet logging | workflows/Webhook + workflows/Googlesheets | 2-4 |
| Calendly → SMS confirmation | workflows/Calendly + workflows/Twilio | 4-6 |
| Shopify order notifications | workflows/Shopify + workflows/Slack | 4-6 |
| Google Sheets → scheduled reports | workflows/Googlesheets + workflows/Emailsend | 2-4 |
| RSS → Slack/email digest | workflows/Rssfeedread + workflows/Slack | 2-4 |

### Tier 2: Template + Customization (3-6 hours)
Need moderate customization but templates provide 50-70% of the work.

| Job Type | Our Template Source | Connects to Spend |
|----------|-------------------|-------------------|
| WhatsApp/Telegram chatbot | workflows/Whatsapp + workflows/Openai | 6-8 |
| Lead capture → CRM → email sequence | workflows/Webhook + workflows/Hubspot + workflows/Gmail | 6-8 |
| AI content pipeline | workflows/Openai + workflows/Wordpress | 6-8 |
| Invoice/payment automation | workflows/Paypal + workflows/Googlesheets | 4-6 |
| Social media auto-posting | workflows/Twitter + workflows/Linkedin | 6-8 |

### Tier 3: Custom Build (6-12 hours)
Significant custom work but high-value jobs ($500-2,000+).

| Job Type | Approach | Connects to Spend |
|----------|----------|-------------------|
| Full CRM + automation setup | Multiple templates + custom logic | 8-12 |
| AI agent / chatbot with memory | OpenAI + database + custom code | 8-12 |
| Multi-step approval workflows | Custom but n8n's UI makes it fast | 8-12 |
| Data migration + transformation | Template ETL patterns + custom mapping | 8-12 |

---

## Search Queries to Run Daily

```
n8n automation
n8n workflow
workflow automation api integration
zapier to n8n migration
make.com alternative
ai chatbot integration
twilio sms automation
slack bot automation
google sheets automation
crm automation hubspot pipedrive
lead generation automation
email automation workflow
whatsapp business api
telegram bot n8n
shopify automation
booking automation calendly
```

## Proposal Formula (Compressed)

Use proposal-writing skill for full version. Quick Upwork format:

```
Line 1: Reference THEIR specific need (proves you read it)
Line 2: "I've built [similar thing] — [result]"
Line 3: "I'd use n8n to [approach], delivering [outcome] in [timeframe]"
Line 4: "Happy to do [small first milestone] so you can evaluate"
Line 5: Question about their requirements (invites response)
```

**Key differentiators to mention:**
- "I have a live n8n instance and can demo your workflow within 24 hours"
- "I maintain a library of 2,000+ tested workflow templates"
- "Your automation runs on YOUR infrastructure — no monthly SaaS fees"
- "Includes documentation so your team can maintain it"

---

## Connect Spend Strategy

Starting budget: 100 connects ($15 investment)

**Allocation:**
- 60% on Tier 1 jobs (high win probability, quick delivery, build reviews)
- 30% on Tier 2 jobs (higher revenue, moderate effort)
- 10% on Tier 3 jobs (moonshots, big payoff if won)

**Target:** Win 2-3 jobs in first 2 weeks. Focus on 5-star reviews over revenue initially.

**Refill connects when:** 
- Win rate >15% (good — keep spending)
- Win rate <10% (pause — improve proposals first)

---

## Job Evaluation Scorecard

Before spending connects, score the job:

| Factor | Score 1-5 | Weight |
|--------|-----------|--------|
| Budget realistic for scope | | 25% |
| Template coverage (how much is pre-built) | | 25% |
| Client quality (rating, history, verification) | | 20% |
| Competition (<15 proposals) | | 15% |
| Follow-on potential (recurring/upsell) | | 15% |

**Bid threshold:** 3.5+ weighted score
**Auto-skip:** Any factor scores 1

---

## First 30 Days Playbook

**Week 1:** Bid on 8-10 Tier 1 jobs. Goal: win 2, deliver fast, get 5-star reviews.
**Week 2:** Bid on 5-8 mixed Tier 1+2. Goal: win 2 more, start building profile credibility.
**Week 3:** Raise rate from $49 to $59/hr. Start bidding Tier 2 exclusively.
**Week 4:** Target 1-2 Tier 3 jobs ($500+). Profile now has 4+ reviews.

**Revenue target:** $800-1,200 in first 30 days. Combined with Alfred ($149/mo), that's $950-1,350/mo — closing in on $2K goal.
