# Progress Tracking & Analytics

## Core Metrics

### Time Invested
- Total hours per degree
- Hours per module
- Hours this week/month
- Trend: increasing, stable, declining

### Completion Progress
- Modules completed / total
- Content consumed (pages, videos, etc.)
- Exercises completed
- Percentage complete

### Mastery Level
- Per-topic mastery scores
- Overall weighted average
- Change over time
- Comparison with targets

### Retention
- Spaced repetition performance
- Forgetting rate by topic
- Items needing more review
- Long-term retention trends

## Dashboard Views

### Quick Glance
```
[Degree Name] - 34% Complete
├── This Week: 8h studied
├── Mastery: 72% average
├── Next Deadline: Exam in 12 days
└── Due Today: 15 flashcards
```

### Detailed Breakdown
```
Module Progress
| Module | Studied | Mastery | Status |
|--------|---------|---------|--------|
| Mod 1  | 12h     | 85%     | ✅     |
| Mod 2  | 8h      | 60%     | 🔄     |
| Mod 3  | 0h      | -       | ⬜     |

Time This Week
Mon: 2h | Tue: 1.5h | Wed: 0h | Thu: 2h | Fri: 1h
Target: 10h | Actual: 6.5h | Pace: Behind
```

## Predictions

### Exam Readiness
- Predicted score based on current mastery
- Confidence interval (best/worst case)
- Topics most likely to affect score
- Days to reach target score (if continuing pace)

### Completion Date
- Original target date
- Current projected date (based on actual pace)
- Variance and trend
- What's needed to get back on track

### Risk Indicators
- 🟢 On track
- 🟡 Slightly behind, recoverable
- 🔴 Significantly behind, action needed

## Comparative Analytics

### Personal History
- This week vs last week
- This month vs last month
- Performance trends over time

### Vs Plan
- Actual hours vs planned hours
- Actual progress vs planned progress
- Areas where estimates were wrong

### Learning Patterns
- Best day of week for studying
- Best time of day
- Optimal session length
- Topics that take longer than expected

## Gap Analysis

### Knowledge Gaps
- Topics with < 60% mastery
- Topics studied long ago (retention risk)
- Prerequisites for upcoming material
- Common error patterns

### Schedule Gaps
- Weeks with insufficient study time
- Modules behind schedule
- Deadlines at risk

### Resource Gaps
- Topics lacking good resources
- Areas needing additional material
- Practice questions exhausted

## Reports

### Weekly Summary
Generated automatically:
- Hours studied
- Modules progressed
- New material covered
- Mastery improvements
- Upcoming week preview

### Monthly Report
- Progress toward degree completion
- Average pace sustainability
- Major milestones reached
- Adjustments made
- Next month focus

### Pre-Exam Report
- Topic-by-topic readiness
- Weak areas to focus
- Predicted performance
- Study recommendations
- Confidence assessment

## Motivation & Accountability

### Streaks
- Current study streak (days)
- Longest streak
- Streak recovery (grace days)

### Milestones
- Celebrate module completions
- Track certificates earned
- Visualize progress (progress bar)
- Share achievements (optional)

### Alerts
- "You haven't studied [topic] in 14 days"
- "Mastery in [topic] is declining"
- "5 days until deadline, 3 modules to go"
- "You're ahead of schedule!" (positive reinforcement)

## Parent/Tutor View

When in tutor mode, separate dashboard:
- What was studied this week
- Where struggling
- Upcoming deadlines
- How to help (specific suggestions)
- Appropriate level of detail (not micromanaging)
