# Planning & Calendar

## Initial Setup

### Availability Assessment
1. Hours per week available for study
2. Best times of day (energy/focus)
3. Non-negotiable commitments (work, family)
4. Seasonal variations (exams at work, holidays)

### Goal Setting
- Target completion date (if any)
- Priority order of modules
- Milestone definitions
- Minimum viable progress per week

## Daily Planning

### Morning Briefing
Generate each morning:
- What's on today's study plan
- Any deadlines approaching (< 7 days)
- Review items due (spaced repetition)
- Suggested focus time blocks

### Session Generation
When user has time to study:
1. Ask: How much time? (15 min, 1 hour, 3 hours)
2. Generate session:
   - X% new material
   - Y% practice/exercises  
   - Z% review (flashcards, past tests)
3. Adapt to energy: fresh → new material, tired → review

### End of Day
- Log what was completed
- Reschedule what wasn't
- Update progress tracking
- Preview tomorrow

## Weekly Planning

### Weekly Review
Every Sunday (or configured day):
- Hours studied this week
- Modules progressed
- Mastery changes
- What worked / what didn't
- Adjustments for next week

### Weekly Plan
- Distribute remaining work across days
- Buffer for unexpected (don't pack 100%)
- One "catch-up" slot for slippage
- Balance across multiple degrees if applicable

## Exam-Focused Planning

### Countdown Mode
When exam date is set:
1. Calculate weeks remaining
2. Divide remaining material
3. Reserve last 2 weeks for review only
4. Build in practice exam simulations
5. Alert if pace insufficient

### Pre-Exam Week
- No new material (review only)
- Daily practice tests
- Focus on weak areas
- Reduce study hours (avoid burnout)

### Multiple Exams
- Prioritize by date and difficulty
- Interleave study to prevent interference
- Post-exam recovery day before next prep

## Long-Term Planning

### Semester/Quarter View
- All deadlines on unified calendar
- Color-coded by degree/course
- Milestone markers
- Holiday/break periods

### Year Planning
- Which degrees/certifications this year
- Realistic pacing (no 3 certs in one month)
- Career alignment (what opens doors first)
- Review and adjust quarterly

## Adaptive Rescheduling

### Automatic Adjustments
When user misses planned study:
- Don't guilt trip
- Redistribute missed content
- Prioritize critical items
- Adjust future estimates if pattern emerges

### Manual Overrides
- User can reschedule anything
- "Not today" pushes to tomorrow
- "Skip this week" recalculates
- "I finished early" advances next

### Handling Delays
If consistently behind:
1. Alert user (not panic, just inform)
2. Options: extend timeline, reduce scope, increase hours
3. Recalculate completion date
4. Focus on most critical content if time-crunched

## Integration with Real Life

### Calendar Sync
- Import external calendars (work, personal)
- Detect free slots automatically
- Avoid double-booking study time
- Respect blocked times

### Notifications
- Configurable: email, push, none
- Types: daily summary, deadline warnings, review reminders
- Timing: morning briefing, session reminders
- Frequency: not spammy, respect "do not disturb"

### Travel/Breaks
- Vacation mode: pause tracking, no guilt
- Light mode: minimal review only
- Catch-up mode: accelerated return
