# Study Formats & Methods

## Flashcards

### Generation
- Automatic from any content (PDFs, notes, lectures)
- Q&A format: question on front, answer on back
- Cloze deletion: "The mitochondria is the [blank] of the cell"
- Image-based: diagrams with labeled parts

### Organization
- By module/topic
- By difficulty
- By due date (spaced repetition)
- By mastery level

### Review
- Daily review queue
- Configurable session length
- Self-rate: easy/medium/hard
- Interval adjustment based on rating

### Export
- Anki-compatible format
- CSV for other apps
- Print-friendly PDF

## Audio Learning

### Generated Podcasts
- Convert any content to conversational audio
- Ideal for: commutes, walks, exercise
- Include: summaries, explanations, embedded questions
- Pace: slower than reading, with pauses

### Dictation
- Read summaries aloud
- Key terms repeated
- Pronunciation of technical vocabulary
- Available in multiple voices/speeds

### Audio Flashcards
- Question spoken → pause → answer spoken
- Great for language learning
- Works without looking at screen

## Visual Learning

### Mind Maps
- Central concept with branches
- Color-coded by importance/module
- Collapsible levels
- Export as image

### Diagrams & Charts
- Process flows
- Timelines
- Comparison tables
- Hierarchies

### Video Summaries
- Key points with visuals
- Animations for processes
- Shorter than original lectures

## Active Recall Methods

### Self-Testing
- Generate questions before looking at answers
- Write/speak answer before checking
- Never passive rereading

### Feynman Technique
- Explain concept in simple terms
- Identify gaps in understanding
- Research gaps, re-explain
- Simplify further

### Teach-Back
- Pretend teaching someone else
- Verbalize the explanation
- Agent asks clarifying questions
- Evaluates quality of explanation

## Practical Application

### Problem Sets
- Practice exercises with solutions
- Increasing difficulty
- Timed practice
- Step-by-step hints available

### Case Studies
- Real-world scenarios
- Apply theoretical knowledge
- Multiple valid approaches
- Professional format output

### Projects
- Hands-on application
- Portfolio-worthy outcomes
- Guided but not spoon-fed
- Code review / feedback on output

### Simulations
- Mock scenarios (medical, legal, business)
- Decision-making practice
- Consequences of choices shown
- Safe environment to fail

## Time-Based Techniques

### Pomodoro
- 25-minute focus blocks
- 5-minute breaks
- Longer break every 4 cycles
- Track completed pomodoros

### Time Boxing
- Allocate fixed time to topic
- Move on regardless of completion
- Prevents getting stuck
- Ensures coverage

### Spaced Practice
- Distribute study over days
- Interleave topics (don't block)
- Schedule returns to material
- Automatic via spaced repetition

## Personalization

### Learning Style Detection
- Track which formats produce best retention
- Adjust recommendations accordingly
- User can override preferences

### Energy-Based Selection
- High energy → new, hard material
- Low energy → review, flashcards
- Tired → audio, light review

### Preferences Stored
In config.md:
- Preferred format by topic type
- Session length preferences
- Audio/visual/kinesthetic balance
- Break frequency

## Micro-Learning

### 5-Minute Sessions
- One flashcard set
- One concept review
- One quick quiz
- For waiting rooms, transit, breaks

### 15-Minute Sessions
- One topic review
- Short practice set
- Combine review + new

### Full Sessions (1+ hour)
- New material + practice + review
- Deeper topic exploration
- Project work
- Exam simulation
