# Assessment & Examination

## Types of Assessment

### Multiple Choice Tests
- Generate questions from studied material
- Include: correct answer + 3-4 plausible distractors
- Difficulty levels: easy, medium, hard, exam-level
- Explain wrong answers: WHY is each option incorrect?

### Short Answer / Essay
- Open-ended questions requiring explanation
- Grade for: accuracy, completeness, clarity
- Provide model answers after attempt
- Highlight: what was missing, what was good

### Problem Solving (STEM)
- Generate problems similar to course exercises
- Step-by-step verification of solution
- Partial credit: identify where error occurred
- Similar problems for weak areas

### Case Studies (Business, Law, Medicine)
- Real-world scenarios requiring analysis
- Multiple valid approaches possible
- Evaluate: reasoning process, not just conclusion
- Professional format (legal brief, medical notes, etc.)

### Oral Examinations
- Simulate tribunal/viva setting
- Ask follow-up questions based on answers
- Evaluate: knowledge depth, communication, composure
- Record responses for self-review

### Practical/Lab Assessments
- Code review and testing
- Procedure verification
- Safety and methodology checks
- Output evaluation

## Full Exam Simulation

### Setup
1. Select topics/scope (full exam or partial)
2. Set time limit matching real exam
3. Choose format (timed strict or flexible)
4. Disable helps during exam

### During Exam
- Timer visible
- No hints or explanations
- Flag questions for review
- Submit when done or time expires

### After Exam
- Immediate score and breakdown by topic
- Detailed correction of each question
- Comparison with passing threshold
- Recommendations for improvement

## Mastery Tracking

### Per-Topic Scores
```
| Topic | Tests Taken | Avg Score | Last Score | Trend |
|-------|-------------|-----------|------------|-------|
| Topic A | 5 | 78% | 85% | ↑ |
| Topic B | 3 | 62% | 60% | → |
| Topic C | 2 | 45% | 50% | ↑ |
```

### Mastery Levels
- **Not started:** No assessment yet
- **Learning:** <60% — needs more study
- **Developing:** 60-79% — partial understanding
- **Proficient:** 80-89% — solid grasp
- **Mastered:** 90%+ — ready for exam

### Predicted Exam Score
Based on:
- Topic mastery × topic weight in exam
- Recent performance trend
- Performance under timed conditions
- Comparison with historical pass rates

## Spaced Repetition for Retention

### Scheduling Reviews
- New material: review in 1 day, 3 days, 1 week, 2 weeks, 1 month
- Failed items: reset to 1-day interval
- Mastered items: extend intervals (1 month → 3 months)
- Adaptive: adjust based on user's actual retention

### Review Sessions
- Daily review queue from all active degrees
- Prioritize: items due today > overdue items
- Mix: don't group all items from same topic
- Duration: configurable (10 min quick, 30 min deep)

### Tracking Forgetting
- If an item is forgotten, log it
- Identify patterns: topics that fade faster
- Adjust study approach for sticky topics

## Exam Day Preparation

### Day Before
- Light review only (no cramming)
- Focus on weak spots one more time
- Logistics check (location, materials, ID)
- Sleep and rest advice

### Morning Of
- Quick confidence boost (what you know well)
- Don't start new topics
- Arrival time planning
- Mindset preparation

### During Exam
- Time management strategy per section
- Which questions to attempt first
- When to move on from hard questions
- Review strategy if time remains

## After Exam

### If Failed
- Analyze where points were lost
- Identify if preparation or execution issue
- Adjust study plan for next attempt
- Maintain motivation (many successful people failed first)

### If Passed
- Celebrate appropriately
- Archive exam prep materials
- Connect learning to next steps
- Update progress in degree tracking
