# Domestic Transport — United States

## Mode Selection Framework

| Route type | Default winner | Why |
|-----------|----------------|-----|
| 250-600 miles urban corridor | Rail or short flight | Depends on station/airport access overhead |
| Coast-to-coast or multi-time-zone | Flight | Time-efficient despite airport friction |
| National park loops | Car | Last-mile access and schedule control |
| Dense city core trips | Public transit + walking | Avoid parking, toll, and congestion cost |

## Flight Screening Reality

- TSA liquids rule: carry-on liquids are limited to travel-size containers in one quart-size bag.
- Larger liquid items should go in checked baggage unless explicit exception applies.
- Medical and infant-related exceptions exist but should be prepared for screening.

## Amtrak Baggage Facts

- Standard allowance includes one personal item plus two carry-on items, with size/weight limits.
- On many routes, checked baggage is available (with station and route limitations).
- Typical checked model: two included, with paid additional bags where offered.

## Urban Payment Systems (High-Value for Tourists)

- New York (OMNY): tap contactless card/phone; weekly fare-capping behavior available.
- Los Angeles (TAP): fare capping and transfer rules matter for multi-ride days.
- San Francisco Bay Area (BART + Clipper): distance-based fares, no weekly pass model.

## Transfer Buffers to Add

- Domestic flight to domestic flight: 2-3 hours buffer when separate tickets.
- International arrival to domestic onward: conservative buffer with immigration + baggage.
- Rail to flight same day: only with explicit slack for city transfer.

## Tourist Trap to Flag

Renting a car for city-only itineraries in Manhattan, central San Francisco, central Chicago, or downtown DC often increases cost and stress.

## Source Reminder

See `sources.md` for TSA, Amtrak, OMNY, Metro TAP, and BART links.
