# National Parks — United States

## Entrance and Pass Basics

- Many national park sites are free, but major parks may require entrance fees.
- America the Beautiful interagency passes cover federal recreation entrance/day-use fees at participating agencies.
- Non-resident annual pass options now exist; verify current price and eligibility before purchase.

## Reservation Systems (Critical)

Some high-demand parks or corridors use timed entry or reservations seasonally. Never assume same-day access.

### High-impact examples

- Yosemite: announced no season-wide timed entry system for 2026.
- Rocky Mountain National Park: timed entry permits continue for specific periods/hours in peak season.
- Reservation release calendars and processing fees can decide whether a park-focused trip works.

## Reservation Workflow

1. Identify target parks and exact dates first.
2. Check each park for reservation/timed-entry requirements.
3. Book permits before non-refundable lodging where possible.
4. Keep a backup park/day plan in case of sold-out windows.

## Parks Logistics Rules

- One park per day is often enough in peak season.
- Start early for parking and lower trail congestion.
- Use shuttle systems where provided.
- Heat, altitude, and wildfire conditions can change route safety quickly.

## App Stack for Park Trips

- NPS App for official park content and offline downloads.
- Recreation.gov for reservations and permit workflows.
- AirNow + weather alerts for smoke and storm checks.

## Source Reminder

See `sources.md` for NPS passes, Yosemite, RMNP, and NPS app links.
