# Entry and Documents — United States

## Fast Decision Tree

1. If traveler is from a Visa Waiver Program country, check ESTA eligibility.
2. If not VWP-eligible, route to B-1/B-2 visitor visa workflow.
3. Verify passport validity and that traveler can prove return/onward intent.
4. For domestic U.S. flights, confirm acceptable ID before final booking.

## Visitor Pathways

| Path | Typical use | Core limit |
|------|-------------|------------|
| Visa Waiver Program + ESTA | Tourism/business short stay | Up to 90 days per trip |
| B-1/B-2 visitor visa | Tourism/business when ESTA not applicable | Length decided at admission |

## ESTA Practical Notes

- ESTA authorization allows travel attempt, not guaranteed admission.
- Approved ESTA is generally valid for 2 years or until passport expiry (whichever comes first).
- Multiple trips are possible while valid, with each stay capped by VWP rules.

## I-94 Essentials

- I-94 arrival/departure records are mostly electronic now.
- Travelers can retrieve their most recent I-94 online.
- Land-border travelers can apply in advance using CBP tools when relevant.

## Domestic Flight ID Rules

- REAL ID enforcement began on May 7, 2025 for U.S. domestic screening.
- A passport remains an acceptable alternative for domestic flights.
- If traveler is unsure, ask them to verify accepted ID before ticket finalization.

## Interview and Visa Timing

For B-1/B-2 cases:
- Visa interview wait times vary by post and season.
- Apply early; avoid tight trips that depend on uncertain interview slots.

## Checklist Before Locking Non-Refundables

- Correct entry pathway confirmed (ESTA or visa)
- Passport validity checked for entire trip
- I-94 and admission status understood when relevant
- Domestic ID readiness confirmed for internal flights
- Backup plan if entry/admin timelines slip

## Source Reminder

Use `sources.md` for official links and refresh targets.
