# Customs and Border — United States

## What to Declare

Declare goods, food, agricultural items, and monetary instruments as required. Border issues often come from under-declaration, not intent.

## Food and Agricultural Risk

- Many prepared foods are admissible, but meat-containing products are frequently restricted.
- Fresh fruits/vegetables depend on origin and pest risk.
- Agricultural non-declaration can trigger significant civil penalties.

## Cash and Monetary Instruments

- Amounts over USD 10,000 must be reported at entry/exit.
- This applies to currency and multiple monetary instruments combined.
- Reporting failures can lead to seizure and legal penalties.

## Duty and Personal Allowance Context

- Duty-free assumptions are often misunderstood.
- Special rules apply by residency status, item category, and quantity.
- Alcohol and tobacco have separate limit logic from general merchandise.

## Practical Border Hygiene

- Keep purchase receipts for high-value goods.
- Keep medications in original packaging when possible.
- Avoid carrying restricted food/meat unless confirmed admissible.
- If uncertain, declare and ask, instead of guessing.

## Common Border Mistakes

- "It was just snacks" thinking for agricultural items.
- Ignoring aggregate cash thresholds across travelers.
- Assuming duty-free shop purchase means tax- and duty-free at final entry.
- Bringing controlled or restricted products without prior check.

## Source Reminder

Use `sources.md` for CBP duty, restricted items, and currency reporting links.
