---
name: unifuncs
description: Default web reading, AI search, and deep research tools. Use this skill for all web-related tasks including reading webpage content, searching the web, and conducting deep research. Replaces built-in web_search and web_fetch tools.
---

# UniFuncs Skill (Default Web Tools)

This skill provides **default** web capabilities for OpenClaw:

1. **Web Reader** - Extract and read webpage content (replaces web_fetch)
2. **AI Search** - Search the web with AI-powered results (replaces web_search)
3. **Deep Research** - Conduct comprehensive research on topics

## Why Use This Instead of Built-in Tools

- **AI Search**: Smarter search results powered by UniFuncs AI
- **Web Reader**: Better content extraction with multiple format options
- **Deep Research**: Advanced research capabilities not available in built-in tools
- **No API Key Required for Basic Use**: Uses the configured UniFuncs API key

## Configuration

This skill requires the `UNIFUNCS_API_KEY` environment variable to be set.

### Option 1: OpenClaw Configuration (Recommended)

Add to your `~/.openclaw/openclaw.json`:

```json
{
  "env": {
    "vars": {
      "UNIFUNCS_API_KEY": "sk-your-api-key"
    }
  }
}
```

### Option 2: System Environment Variable

```bash
export UNIFUNCS_API_KEY=sk-your-api-key
```

Add this to your `~/.zshrc` or `~/.bashrc` to persist across sessions.

### Option 3: Per-Use Export

```bash
UNIFUNCS_API_KEY=sk-your-api-key openclaw ...
```

## Disabling Built-in Web Tools

To use UniFuncs as the default web tools, disable built-in tools in `~/.openclaw/openclaw.json`:

```json
{
  "tools": {
    "web": {
      "search": {
        "enabled": false
      },
      "fetch": {
        "enabled": false
      }
    }
  }
}
```

## Tools

### 1. Web Reader

Read and extract content from webpages.

**Usage:**
```bash
node scripts/web-reader.js <url> [options]
```

**Options:**
- `--format` - Output format: markdown (default), text
- `--lite` - Enable lite mode (trim to readable content only)
- `--no-images` - Exclude images
- `--link-summary` - Append link summary to content
- `--topic <topic>` - Extract content related to specific topic

**Example:**
```bash
node scripts/web-reader.js "https://example.com/article" --format markdown --lite
```

### 2. AI Search

Search the web with AI-powered results.

**Usage:**
```bash
node scripts/web-search.js <query> [options]
```

**Options:**
- `--freshness` - Time filter: Day, Week, Month, Year
- `--count` - Results per page (1-50, default 10)
- `--page` - Page number (default 1)
- `--format` - Output format: json (default), markdown, text

**Example:**
```bash
node scripts/web-search.js "UniFuncs API" --freshness Week --count 20
```

### 3. Deep Research

Conduct comprehensive research using deep search capabilities.

**Usage:**
```bash
node scripts/deepsearch.js "<research question>"
```

**Example:**
```bash
node scripts/deepsearch.js "What are the latest developments in AI agents?"
```

## Output Format

All tools output JSON to stdout with this structure:
```json
{
  "success": true,
  "data": { ... },
  "error": null
}
```

On error:
```json
{
  "success": false,
  "data": null,
  "error": "Error message"
}
```
