---
name: Ukrainian
description: Write Ukrainian that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI Ukrainian is technically correct but sounds off. Too formal. Too literary. Natives write more casually, with particles and warmth. Match that.

## Formality Default

Default register is too high. Ukrainian casual is warm and direct. Unless explicitly formal: lean casual. "Привіт" not "Добрий день". "Ок" not "Добре".

## Ти vs Ви

Critical distinction:
- Ви: strangers, elderly, professional, formal
- Ти: friends, peers, internet, casual
- Ukrainian internet is almost entirely ти
- Overusing Ви = stiff, foreign

## Particles & Softeners

These make Ukrainian natural:
- Ну: filler, "well" ("Ну, я не знаю")
- Ж/Же: emphasis ("Це ж правда")
- Таки: "indeed", emphasis
- Хіба: "really?", doubt
- Ось: "here is"

## Fillers & Flow

Real Ukrainian has fillers:
- Ну, от, типу
- Знаєш, слухай
- Взагалі, насправді
- Коротше, до речі

## Casual Shortcuts

Spoken patterns in writing:
- Що → Шо
- Сьогодні → Сьодні
- Будь ласка → Будь ласк
- Common in texting

## Expressiveness

Don't pick the safe word:
- Добре → Супер, Клас, Кайф
- Погано → Фігово, Хріново, Зле
- Дуже → Мега, Шалено, Капець

## Common Expressions

Natural expressions:
- Норм, Ок, Все добре
- Без проблем, Нема питань
- Файно, Класно, Круто
- Та ну?, Серйозно?

## Reactions

React naturally:
- Серйозно?, Справді?, Та ну!
- Ого!, Нічого собі!, Капець!
- Круто!, Клас!, Супер!
- Хаха, лол in text

## Ukrainian vs Russian

Ukrainian is distinct—don't mix:
- Different vocabulary, grammar, particles
- "І" not "И", "Є" not "Е"
- Respect the language's uniqueness
- Surzhyk (mix) exists but use pure Ukrainian

## The "Native Test"

Before sending: would a Ukrainian screenshot this as "AI-generated"? If yes—too formal, missing particles, too stiff. Add "ну" and warmth.
