---
name: uk-prayer-times
version: 1.0.0
description: Get instant, accurate Islamic prayer times for any UK location. Auto-detects your city or accepts any UK location name (cities, towns, boroughs). Handles typos with smart fuzzy search. Shows Fajr, Sunrise, Dhuhr, Asr, Maghrib, and Isha times in 12-hour format. Uses ISNA calculation method (UK standard) via Aladhan API. Perfect for UK Muslims checking daily salah times.
---

# UK Prayer Times

Get instant, accurate Islamic prayer times for any UK location. Auto-detects your city or accepts any UK location name (cities, towns, boroughs). Handles typos with smart fuzzy search. Shows Fajr, Sunrise, Dhuhr, Asr, Maghrib, and Isha times in 12-hour format. Uses ISNA calculation method (UK standard) via Aladhan API. Perfect for UK Muslims checking daily salah times.

## Usage

**Gives prayer times in the UK based on your location:**
```
prayer times
```

**Specify any UK city:**
```
prayer times Birmingham
prayer times Leicester
prayer times Woolwich
prayer times Tower Hamlets
```

**Specific prayers:**
```
Asr in Leicester
Maghrib in Leicester
Fajr in Woolwich
```

Works with typos: "Leicestr", "Bimringham" - fuzzy search finds it!

## Features

✅ Auto-detects your location (via IP)
✅ Works for ANY UK city, town, or area
✅ Handles typos and misspellings
✅ Shows location clearly at top of results
✅ 12-hour format (AM/PM)
✅ Uses ISNA calculation method (UK standard)

## Examples
```bash
python uk_prayer_times.py
# Auto-detects and shows times

python uk_prayer_times.py London
# Shows times for London

python uk_prayer_times.py Woolwich
# Shows times for Woolwich

python uk_prayer_times.py "Tower Hamlets"
# Shows times for Tower Hamlets (multi-word works!)
```

## Data Sources

- **Prayer Times:** Aladhan API (ISNA method)

## Permissions

- Internet access (to fetch location and prayer times)
- No file system access
- No personal data stored

## Output Format
```
==================================================
🕌 PRAYER TIMES - BIRMINGHAM
📅 08 Feb 2026
==================================================

Fajr:    06:02 AM
Sunrise: 07:39 AM
Dhuhr:   12:23 PM
Asr:     02:38 PM
Maghrib: 05:08 PM
Isha:    06:44 PM

==================================================
```

Location name is displayed clearly at top so you always know which location's times are shown.

## Perfect For

- UK Muslims checking daily prayer times
- Travelers wanting local times
- Anyone who wants fast, accurate salah times
- Works with any UK location - cities, towns, boroughs, neighborhoods

## Version

1.0.0 - Initial release