# UI/UX Pro Max

Searchable UI/UX design databases with CLI for generating complete design systems from natural language queries. Includes 50+ styles, 97 palettes, 57 font pairings, 99 UX rules, and 25 chart types.

## What's Inside

- Design system generation from natural language (`--design-system`)
- Searchable databases across 10 domains (product, style, typography, color, landing, chart, ux, react, web, prompt)
- Stack-specific guidelines (html-tailwind, react, nextjs, vue, svelte, swiftui, react-native, flutter, shadcn, jetpack-compose)
- UX rules prioritized by impact (accessibility, touch, performance, layout, typography, animation, style, charts)
- Persistent design systems with hierarchical page overrides
- Pre-delivery checklist for visual quality, interaction, light/dark mode, layout, and accessibility

## When to Use

- Designing new UI components or pages
- Choosing color palettes and typography
- Reviewing code for UX issues
- Building landing pages or dashboards
- Implementing accessibility requirements

## Installation

```bash
npx add https://github.com/wpank/ai/tree/main/skills/design-systems/ui-ux-pro-max
```

### OpenClaw / Moltbot / Clawbot

```bash
npx clawhub@latest install ui-ux-pro-max
```

### Manual Installation

#### Cursor (per-project)

From your project root:

```bash
mkdir -p .cursor/skills
cp -r ~/.ai-skills/skills/design-systems/ui-ux-pro-max .cursor/skills/ui-ux-pro-max
```

#### Cursor (global)

```bash
mkdir -p ~/.cursor/skills
cp -r ~/.ai-skills/skills/design-systems/ui-ux-pro-max ~/.cursor/skills/ui-ux-pro-max
```

#### Claude Code (per-project)

From your project root:

```bash
mkdir -p .claude/skills
cp -r ~/.ai-skills/skills/design-systems/ui-ux-pro-max .claude/skills/ui-ux-pro-max
```

#### Claude Code (global)

```bash
mkdir -p ~/.claude/skills
cp -r ~/.ai-skills/skills/design-systems/ui-ux-pro-max ~/.claude/skills/ui-ux-pro-max
```

## Related Skills

- [ui-design](../ui-design/) — Design fundamentals and decision-making
- [web-design](../web-design/) — CSS implementation patterns
- [frontend-design](../../frontend/frontend-design/) — Creative aesthetics

---

Part of the [Design Systems](..) skill category.
